/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_tests/src/com/sap/tc/jtools/jlint/tests/MethodCalls.java#2 $
 */

package com.sap.tc.jtools.jlint.tests;

import java.util.*;

import com.sap.tc.jtools.jlint.jom.*;

import com.sap.tc.jtools.jlint.jom.interfaces.*;

public class MethodCalls extends JomTestVisitor {

	static public final String TEST_NAME = "Method calls"; //$NON-NLS-1$
	static public final String MESSAGE_METHOD_CALL = "Method_call"; //$NON-NLS-1$
	
	/**
	 * 
	 * Jlin infrastructure
	 * 
	 */

	public MethodCalls() {
	}

	public String getTestName() {
		return TEST_NAME;
	}

	/**
	 * 
	 * End of Jlin infrastructure
	 * 
	 */

	public boolean visit(ICompilationUnit compilationUnitDeclaration) {
		currentCompilationUnit = compilationUnitDeclaration;
		return true;
	}

	public boolean visit(IMethodInvocation methodCall) {
		addError(
			MESSAGE_METHOD_CALL,
			new Properties(),
			methodCall);
		return true;
	}

}
