/*
 * Copyright (c) 2004 by SAP AG, Walldorf.
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_tests/src/com/sap/tc/jtools/jlint/javadiff/tests/XMLConverter.java#2 $
 */
 
package com.sap.tc.jtools.jlint.javadiff.tests;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;

import com.sap.tc.jtools.jlint.javadiff.wrapper.Wrapper;
import com.sap.tc.jtools.jlint.javaelements.Class;
import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLTool;

/**
 * JLin test to convert selected files to the standard format used by the 
 * comparator, and to persist them as XML files. No JLin messages are produced (unless an 
 * internal error occurs).
 * 
 * @author d034036
 * @author d034003
 *
 */
public class XMLConverter extends JomTestVisitor {

	public static final String UTF8_ENCODING = "UTF8";
	static public final String TEST_NAME = "XML Converter"; //$NON-NLS-1$
	static public final String JAVA_EXTENSION_JAVA = ".java"; //$NON-NLS-1$
	static public final String API_SUFFIX = "_api.xml"; //$NON-NLS-1$

	static public final String PARAMETER_OUTPUT_DIRECTORY = "OUTPUT_DIR"; //$NON-NLS-1$
	
	private String[] referenceDirs;
	private static String outputDir;
	private static Properties processedClasses=null;
	private static boolean messageIsGenerated=false;

	public XMLConverter(){
		System.out.println("XMLConverter Constructor called");
	}
	
	public String getTestName() {
		return TEST_NAME;
	}

	public boolean visit(ITypeDeclaration typeDeclaration) {
		if (outputDir==null){
			System.out.println("Unexpected controll flow");
		}
		if (!messageIsGenerated){
			super.addError("apidiff.19",null);
			messageIsGenerated=true;
		}
        String packageAndClass; 
        StringBuffer packageName=new StringBuffer();
        String className;
		StringBuffer currentDir = new StringBuffer(outputDir);
		String[] packageNameComponents =
			typeDeclaration.resolveBinding().getPackage().getNameComponents();
		for (int i = 0; i < packageNameComponents.length; i++) {
			currentDir.append(File.separator);
			currentDir.append(packageNameComponents[i]);
			packageName.append(packageNameComponents[i]);
			packageName.append(".");
		}

		File dir = new File(currentDir.toString());
		if (!dir.isDirectory()) {
			dir.mkdirs();
		}
		className = typeDeclaration.getName().getIdentifier();
		packageName.append(className);
		packageAndClass =  packageName.toString();
		boolean isAPI = false;
		CodeClassification classif = new CodeClassification(referenceDirs);
		isAPI = classif.isApi(this.testObject,packageAndClass);
		if (!isAPI) {
			// generate XML for source classified as API only 
			return false;
		}
		
		if (processedClasses.containsKey(packageAndClass)){
			Properties prop =new Properties();
			prop.put("packageAndClass",packageAndClass);
			super.addError("apidiff.19",prop);
			/** 
			 * Fehler: Eine Klasse ist mehrfach vorhanden / übersetzt worden. 
			 * Oder das Tool läuft zum 2. Mal: DC/Projektname als Property-Value eintragen
			 * und hier vergleichen.
			 */ 
		}
		processedClasses.put(packageAndClass,"API"); // Set projekt-name here.
		File xmlOutFile = new File(dir, className + API_SUFFIX);
		Writer writer = null;
		try {
			FileOutputStream outStream = new FileOutputStream(xmlOutFile);
			writer = new BufferedWriter(new OutputStreamWriter(outStream, UTF8_ENCODING));
			Class typeWrapper = Wrapper.wrap(typeDeclaration);
			StructureTree outputTree = typeWrapper.toStructureTree();
			XMLTool.writeDocument(outputTree, writer);
			writer.flush();
		} catch (IOException e) {
			logException(e);
		} finally {
			if (writer != null) {
				try {
					writer.close();
				} catch (IOException e1) {
					logException(e1);
				}
			}
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.TestComponentInterface#setParameters(com.sap.tc.jtools.jtci.interfaces.ParameterInterface[], com.sap.tc.jtools.jtci.TestObject)
	 */
	public void setParameters(ParameterInterface[] parameters,
			TestObject testObject) {
		super.setParameters(parameters, testObject);
		System.out.println("setParameters called ");
		referenceDirs =
			(String[]) getParameter(APIDiff.PARAMETER_REFERENCE_DIRECTORY).getValue();
		outputDir = (String) getParameter(PARAMETER_OUTPUT_DIRECTORY).getValue();
		if (outputDir.endsWith("\\") || outputDir.endsWith("/")) {
			// remove trailing (back)slash
			outputDir = outputDir.substring(0, outputDir.length() - 1);
		}
		if (processedClasses==null){
			processedClasses = APIDiffUtil.loadProcessedClasses(outputDir+"/ClassesInOldApi.properties");
		}
		messageIsGenerated=false;
	}
	
	public ResultInterface[] processErrors(ResultInterface[] params){
		if (outputDir!=null){
			APIDiffUtil.saveProcessedClasses(outputDir+"/ClassesInOldApi.properties",processedClasses);
			outputDir=null;
		}
		// ToDo: Die Dummy-Message wieder rausfiltern. 
		return super.processErrors(params);
	}
	
}
