/*
 * Created on Dec 2, 2004
 * Moved some inner class out of APIDiff, it seemed to be to large. 
 */
package com.sap.tc.jtools.jlint.javadiff.tests;

import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

import com.sap.tc.jtools.jlint.javadiff.comparator.ListenerInterface;
import com.sap.tc.jtools.jlint.javaelements.ClassInterface;
import com.sap.tc.jtools.jlint.javaelements.FieldInterface;
import com.sap.tc.jtools.jlint.javaelements.MethodInterface;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration;
import com.sap.tc.jtools.jlint.jom.util.NameTool;

/**
 * @author d034003
 *
 */
class Listener implements ListenerInterface {

	private ITypeDeclaration currentClass;
	private String packageName;
	APIDiff visitor;
	
    public Listener(String packageName, APIDiff visitor){
    	this.packageName = packageName;
    	this.visitor =visitor;
    }
	public void setClass(ITypeDeclaration cls) {
	  currentClass = cls;
	}

	public void extraFieldIn1(FieldInterface f1) {
	  String fieldName = f1.getName();
	  IFieldDeclaration fd = findField(f1);
	  Properties properties = new Properties();
	  properties.setProperty("FIELD_NAME", fieldName);
	  visitor.addError(
		APIDiff.MSG_KEY_EXTRA_FIELD,
		properties,
		fd);
	}

	public void extraFieldIn2(FieldInterface f2) {
	  String fieldName = f2.getName();
	  Properties properties = new Properties();
	  properties.setProperty("FIELD_NAME", fieldName);
	  visitor.addError(
	  APIDiff.MSG_KEY_MISSING_FIELD,
		properties,
		findClass(getFullClassName(f2.getDefiningClass())));
	}

	public void extraMethodIn1(MethodInterface method1) {

	  StringBuffer signature = new StringBuffer();
	  String[] parTypes = method1.getParameterTypes();
	  for (int i = 0; i < parTypes.length; i++) {
		if (i > 0) {
			signature.append(", ");
		}
		signature.append(parTypes[i]);
	  }

	  String methodName = method1.getMethodName();

	  IMethodDeclaration md = findMethod(method1);

	  Properties properties = new Properties();
	  properties.setProperty(
		"METHOD_NAME",
		(methodName == null ? "<constructor>" : methodName) + "(" + signature.toString() + ")");
		visitor.addError(
	  APIDiff.MSG_KEY_EXTRA_METHOD,
		properties,
		md);

	}

	public void extraMethodIn2(MethodInterface method2) {

	  String methodName = method2.getMethodName();
	  StringBuffer signature = new StringBuffer();
	  String[] parTypes = method2.getParameterTypes();
	  for (int i = 0; i < parTypes.length; i++) {
		if (i > 0) {
			signature.append(", ");
		}
		signature.append(parTypes[i]);
	  }

	  Properties properties = new Properties();

	  properties.setProperty(
		"METHOD_NAME",
		(methodName == null ? "<constructor>" : methodName) + "(" + signature.toString() + ")");
		visitor.addError(
	  APIDiff.MSG_KEY_MISSING_METHOD,
		properties,
		findClass(getFullClassName(method2.getDefiningClass()))
		  );

	}

	public void differentMethodSignatures(
	  MethodInterface method1,
	  MethodInterface method2) {
	  // new signature
	  String methodName = method1.getMethodName();
	  StringBuffer signature = new StringBuffer();
	  String[] parTypes = method1.getParameterTypes();
	  for (int i = 0; i < parTypes.length; i++) {
		if (i > 0) {
			signature.append(", ");
		}
		signature.append(parTypes[i]);
	  }

	  // refernce signature
	  String refMethodName = method2.getMethodName();
	  StringBuffer refSignature = new StringBuffer();
	  String[] parTypes2 = method2.getParameterTypes();
	  for (int i = 0; i < parTypes2.length; i++) {
		if (i > 0) {
			refSignature.append(", ");
		}
		refSignature.append(parTypes2[i]);
	  }

	  IMethodDeclaration md = findMethod(method1);
	  Properties properties = new Properties();
	  properties.setProperty(
		"METHOD_NAME",
		(methodName == null ? "<constructor>" : methodName) + "(" + signature.toString() + ")");
	  properties.setProperty(
			"REF_METHOD_NAME",
			(refMethodName == null ? "<constructor>" : refMethodName) + "(" + refSignature.toString() + ")");
		visitor.addError(
	  APIDiff.MSG_KEY_CHANGED_SIGNATURE,
		properties,
		md);
	}

	public void differentClassModifiers(ClassInterface c1, ClassInterface c2) {
	  Properties properties = new Properties();
	  properties.setProperty("MOD_1", NameTool.getHumanReadableModifiers(c1.getModifiers()));
	  properties.setProperty("MOD_2", NameTool.getHumanReadableModifiers(c2.getModifiers()));
	  visitor.addError(
	  APIDiff.MSG_KEY_CHANGED_MODIFIERS,
		properties,
		findClass(c1));
	}

	public void differentMethodModifiers(
	  MethodInterface m1,
	  MethodInterface m2) {

	  IMethodDeclaration md = findMethod(m1);
	  Properties properties = new Properties();
	  properties.setProperty("MOD_1", NameTool.getHumanReadableModifiers(m1.getModifiers()));
	  properties.setProperty("MOD_2", NameTool.getHumanReadableModifiers(m2.getModifiers()));
	  visitor.addError(
	  APIDiff.MSG_KEY_CHANGED_MODIFIERS,
		properties,
		md);
	}

	public void differentFieldModifiers(FieldInterface f1, FieldInterface f2) {
//		String fieldName = f1.getName();
	  IFieldDeclaration fd = findField(f1);
	  Properties properties = new Properties();
	  properties.setProperty("MOD_1", NameTool.getHumanReadableModifiers(f1.getModifiers()));
	  properties.setProperty("MOD_2", NameTool.getHumanReadableModifiers(f2.getModifiers()));
	  visitor.addError(
	  APIDiff.MSG_KEY_CHANGED_MODIFIERS,
		properties,
		fd);

	}

	public void differentSuperclass(ClassInterface c1, ClassInterface c2) {
	  Properties properties = new Properties();
	  String tmp = c1.getSuperclass();
	  if (tmp==null){
	  	tmp="null";
	  }
	  properties.setProperty("SC_1", tmp);
	  tmp = c2.getSuperclass();
	  if (tmp==null){
		tmp="null";
	  }
	  properties.setProperty("SC_2", tmp);
	  visitor.addError(
	  APIDiff.MSG_KEY_CHANGED_SUPERCLASS,
		properties,
		findClass(c1));
	}

	public void extraSuperInterfaceIn1(ClassInterface c1, String si) {
	  Properties properties = new Properties();
	  properties.setProperty("INTERFACE", si);
	  visitor.addError(
	  APIDiff.MSG_KEY_EXTRA_SI,
		properties,
		findClass(c1));
	}

	public void extraSuperInterfaceIn2(ClassInterface c1, String si) {
	  Properties properties = new Properties();
	  properties.setProperty("INTERFACE", si);
	  visitor.addError(
	  APIDiff.MSG_KEY_MISSING_SI,
		properties,
		findClass(c1));

	}

	public void extraClassIn1(ClassInterface cl, ClassInterface cls) {
	  Properties properties = new Properties();
	  visitor.addError(
	  APIDiff.MSG_KEY_EXTRA_CLASS,
		properties,
		findClass(cls));
	}

	public void extraClassIn2(ClassInterface cl, ClassInterface cls) {
	  Properties properties = new Properties();
	  properties.setProperty("CLASS", cls.getClassName());
	  visitor.addError(
	  APIDiff.MSG_KEY_MISSING_CLASS,
		properties,
		findClass(cl));

	}

	public void differentReturnTypes(MethodInterface m1, MethodInterface m2) {
	  String signature = "";
	  String[] parTypes = m1.getParameterTypes();
	  for (int i = 0; i < parTypes.length; i++) {
		signature += parTypes[i] + ";";
	  }

	  IMethodDeclaration md = findMethod(m1);
	  Properties properties = new Properties();
	  properties.setProperty("RT_1", m1.getReturnType());
	  properties.setProperty("RT_2", m2.getReturnType());
	  visitor.addError(
	  APIDiff.MSG_KEY_CHANGED_RETURN_TYPE,
		properties,
		md);
	}

	public void differentExceptions(MethodInterface m1, MethodInterface m2) {
	  Properties properties = new Properties();
	  String exc1 = "";
	  String[] et1 = m1.getExceptionTypes();
	  for (int i = 0; i < et1.length; i++) {
		exc1 += et1[i] + ", ";
	  }

	  String exc2 = "";
	  String[] et2 = m2.getExceptionTypes();
	  for (int i = 0; i < et2.length; i++) {
		exc2 += et2[i] + ", ";
	  }
	  properties.setProperty("EXC_1", exc1);
	  properties.setProperty("EXC_2", exc2);
	  visitor.addError(
	  APIDiff.MSG_KEY_CHANGED_EXCEPTIONS,
		properties,
		findMethod(m1));

	}

	public void differentFieldTypes(FieldInterface f1, FieldInterface f2) {
	  Properties properties = new Properties();
	  properties.setProperty("TYPE_1", f1.getType());
	  properties.setProperty("TYPE_2", f2.getType());
	  visitor.addError(
	  APIDiff.MSG_KEY_CHANGED_FIELD_TYPE,
		properties,
		findField(f1));
	}

	public void differentFieldValues(FieldInterface f1, FieldInterface f2) {
	  Properties properties = new Properties();
	  String value1 = f1.getValue();
	  String value2 = f2.getValue();
	  properties.setProperty("VALUE_1", value1 == null ? "<null>" : value1);
	  properties.setProperty("VALUE_2", value2 == null ? "<null>" : value2);
	  visitor.addError(
	  APIDiff.MSG_KEY_CHANGED_FIELD_VALUE,
		properties,
		findField(f1));

	}

	private String getFullClassName(ClassInterface ci) {
	  return ci.getPckName() == null
		? ci.getClassName()
		: ci.getPckName() + "." + ci.getClassName();
	}

	private ITypeDeclaration findClass(ClassInterface c) {
	  return findClass(getFullClassName(c));
	}

	private ITypeDeclaration findClass(String className) {
	  String topLevelClassName = currentClass.getName().getIdentifier();
	  if (packageName != null) {
		topLevelClassName = packageName + "." + topLevelClassName;
	  }

	  if (!className.startsWith(topLevelClassName)) {
		return null; //something is wrong
	  } else {
		ITypeDeclaration cls = currentClass;
		StringTokenizer tokenizer =
		  new StringTokenizer(
			className.substring(packageName.length() + 1),
			".");
		tokenizer.nextToken();
		tokenLoop : while (tokenizer.hasMoreTokens()) {
		  String element = tokenizer.nextToken();
		  ITypeDeclaration[] innerTypes = cls.getTypes();
		  for (int i = 0; i < innerTypes.length; i++) {
			if (innerTypes[i].getName().getIdentifier().equals(element)) {
			  cls = innerTypes[i];
			  continue tokenLoop;
			}
		  }
		  return null;
		}
		return cls;
	  }
	}

	private IMethodDeclaration findMethod(MethodInterface m) {

	  ITypeDeclaration type = findClass(getFullClassName(m.getDefiningClass()));
	  if (type == null) {
		return null;
	  }
	  String methodName = m.getMethodName();
	  String[] signature = m.getParameterTypes();

	  IMethodDeclaration[] methods = type.getMethods();
	  methodLoop : for (int i = 0; i < methods.length; i++) {
		if ((methods[i].isConstructor() && methodName == null)
		  || (!methods[i].isConstructor()
			&& methods[i].getName().equals(methodName))) {
//			String sig = "";
		  List params = methods[i].parameters();
		  if (params.size() != signature.length) {
			continue methodLoop;
		  }
		  for (int j = 0; j < params.size(); j++) {
			if (!((IVariableDeclaration) params.get(j))
			  .getType()
			  .resolveBinding()
			  .getName()
			  .equals(signature[j])) {
			  continue methodLoop;
			}
		  }
		  return methods[i];
		}
	  }
	  return null;
	}

	private IFieldDeclaration findField(FieldInterface f) {
	  ITypeDeclaration type = findClass(getFullClassName(f.getDefiningClass()));
	  if (type == null) {
		return null;
	  }
	  IFieldDeclaration[] fields = type.getFields();
	  for (int i = 0; i < fields.length; i++) {
		if (fields[i].getName().equals(f.getName())) {
		  return fields[i];
		}
	  }
	  return null;
	}


}
