/*
 * Created on Dec 13, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.sap.tc.jtools.jlint.javadiff.tests;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

/**
 * @author d034003
 *
 * Minimal set of meta information that is required by API-DIFF for one class.
 * Information might be inconsistent; Therefore it is redundant. It is collected 
 * here and reported in the end.
 * Persistet in a hash-map and analysed at the end of nightly build. 
 */
public class InstanceMetaInfo implements Serializable {
	// the following flags are redundant. Initially they are initialized to "false", later on they
	// can only turn to "true", never back. If they both are true in the end, we detected an error.
	// if they both remain false, the value is undefined. 
	private boolean isTest;
	private boolean isNOTTest;
	private boolean isAPI;
	private boolean isRequiredAsAPI;
	private boolean isNOTAPI;
	private Set descendants; // Set of Strings: packageAndClass
	//private Set ancestors; // is it required?
	private String projectName="API";// some default value to avoid nullPointerExceptions when serializing.
	private static final long serialVersionUID=1L;
	
	public InstanceMetaInfo(){
		this.isAPI = false;
		this.isRequiredAsAPI = false;
		isNOTAPI = false;
		isTest = false;
		isNOTTest =false;
		descendants = null;
		//ancestors = null;
		projectName="API";
	}
	
	public void addDescendant(String packageAndClass){
		if (descendants==null){
			descendants=new HashSet();
		}
		descendants.add(packageAndClass);
		isRequiredAsAPI= true;
	}
	
	public Set getDescendants(){
		return descendants;
	}
	
	public String getProjectName(){
		return projectName;
	}
	
	public boolean isAPI(){
		return isAPI;
	}
	
	public boolean isNOTApi(){
		return isNOTAPI;
	}
	
	public boolean isTest(){
		return isTest;
	}
	
	public boolean isNOTTest(){
		return isNOTTest;
	}
	
	public void setIsAPI(boolean value){
		if (value){
			isAPI=true;
		}
		else{
			isNOTAPI = true;
		}
	}
	
	public void setIsTest(boolean value){
		if (value){
			isTest=true;
		}
		else{
			isNOTTest = true;
		}
	}

	public void setIsRequiredAsAPI(boolean value){
		if (value){
			isRequiredAsAPI=true;
		}
	}
		
	void processAPIFlags(String packageAndClass,APIDiff messageHelper){
		// remove all errors that are reported. The must not be persisted. Otherwhise
		// they will be reported over and over again.
		if (isAPI&&isNOTAPI){
			// Error: Classification changed.
			Properties properties = new Properties();
			properties.setProperty("packageAndClass", packageAndClass);
			messageHelper.addError("apidiff.21",properties);
			isNOTAPI=false;
		}  			
		if (isTest&&isNOTTest){
			// Error: Classification changed.
			Properties properties = new Properties();
			properties.setProperty("packageAndClass", packageAndClass);
			messageHelper.addError("apidiff.25",properties);
			isNOTTest=false;
		}  			
		if (isTest&&isAPI){
			// Error: Classification inconsistent.
			Properties properties = new Properties();
			properties.setProperty("packageAndClass", packageAndClass);
			messageHelper.addError("apidiff.26",properties);
			isTest=false;
		}  			
		if (isRequiredAsAPI&& !isAPI){
			// Required but not published
			String descendant;
			Iterator theDescendants = descendants.iterator();
			while (theDescendants.hasNext()){
				descendant = (String)theDescendants.next();
				Properties properties = new Properties();
				properties.setProperty("CLASS", descendant);
				properties.setProperty("ANCESTOR", packageAndClass);
				messageHelper.addError("apidiff.20",properties);
			}	
			isAPI=true;
			isNOTAPI=false;	
		}
	}
}
