/*
 * Created on Dec 3, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.sap.tc.jtools.jlint.javadiff.tests;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

import com.sap.tc.jtools.jlint.java.JavaFileArrayTestObject;
import com.sap.tc.jtools.jlint.javadiff.BinaryConverter;

/**
 * @author d034003
 *
 * TODO: IsApi must be extended to cover NWDI, Japro
 * TODO: Evaluate properties value: Inheritance, usage, both.
 * 
 * check if a class isAPI, isTest and which other classes are allowed to 
 * use this API (ACL evaluation). Offers a set of utility functions for other tests.
 * Should probably be moved to a more central place in JLin.
 * 
 * A class is API if one of the following conditions is true:
 * 1) it is listed in one of the Properties files, default name is "APIclassesAP.properties". 
 * There are many files for all the layers, and several files for the different marking mechanisms.
 * APIClassesAP: class file is in archive pool.
 * APIClassesJavaDoc: there exists javadoc for the class in the archive pool documentation.
 * APIClassesRef: the class is used by an API class.
 * 2) the JLin-classification flags it as an API.
 * 3) TODO: It is part of a compilation public part of NWDI.
 * 4) TODO: whatever mechanism is used for japro.
 * 
 * (not checked here: It is used by an API-Class.) 
 * <br>
 */
public class CodeClassification {
	
	public final static int JAVADOC_DEFINED = 1;
	public final static int AP_DEFINED = 2;
	public final static int USAGE_DEFINE = 4;
	 
    private static Map loadedFileListsAP = new HashMap();	// Key: Filename, Value: Properties-Object with 
    // key: packageAndClass, Value: ??? not used so far. 
	private static Map loadedFileListsJD = new HashMap();	
	private static Map loadedFileListsUS = new HashMap();	
    
	/**
	 * Initialize a code classifier.
	 * 
	 * @param referenceDirs List of folders containing properties files listing all api-classes. 
	 * Property-values are ignored, property-keys are package and class name.
	 */
	public CodeClassification(String[] referenceDirs){	
		int length = referenceDirs.length;
		Map tmp1 = new HashMap();
		Map tmp2 = new HashMap();
		Map tmp3 = new HashMap();
		for (int i=0;i<length;i++){	
			String file1 = referenceDirs[i]+"\\"+BinaryConverter.OUTFILENAME;
			String file2 = referenceDirs[i]+"\\APIClassesJavaDoc.properties";
			String file3 = referenceDirs[i]+"\\missingClasses.properties";
			if (loadedFileListsAP.containsKey(file1)){
				tmp1.put(file1,loadedFileListsAP.get(file1));
			}
			else{
				Properties apiFiles = APIDiffUtil.loadProcessedClasses(file1);
				tmp1.put(file1,apiFiles);
			}		
			if (loadedFileListsJD.containsKey(file2)){
				tmp2.put(file2,loadedFileListsJD.get(file2));
			}
			else{
				Properties apiFiles = APIDiffUtil.loadProcessedClasses(file2);
				tmp2.put(file2,apiFiles);
			}		
			if (loadedFileListsUS.containsKey(file3)){
				tmp3.put(file3,loadedFileListsUS.get(file3));
			}
			else{
				Properties apiFiles = APIDiffUtil.loadProcessedClasses(file3);
				tmp3.put(file3,apiFiles);
			}		
		}
		loadedFileListsAP = tmp1;
		loadedFileListsJD = tmp2;
		loadedFileListsUS = tmp3;
	}
	
	private boolean isApi(Map fileList, String packageAndClass){
		boolean result = false;
		Iterator it;
		Collection values;
		values = fileList.values();
		if (values!=null){
			it = values.iterator();
			String test=null;
			while (it.hasNext()&&(test==null)){
				Properties prop = (Properties)it.next();
				test = (String)prop.get(packageAndClass);			
			}
			if (test!=null){
				return true;
			}
		}
		return result;
	}
	
	public boolean isApi(JavaFileArrayTestObject testObject,String packageAndClass){
		boolean tmp;
		tmp = isApi(loadedFileListsAP,packageAndClass);
		if (tmp){
			return true;
		}
		tmp = isApi(loadedFileListsJD,packageAndClass);
		if (tmp){
			return true;
		}
		tmp = isApi(loadedFileListsUS,packageAndClass);
		if (tmp){
			return true;
		}

		String [] codeClasses = testObject.getCodeClassification();
		for (int i = 0; i < codeClasses.length; i++) {
			if ("api".equals(codeClasses[i])) {
				return true;
			}
		}
		return false;
	}

	public int getReasonForAPI(String packageAndClass){
		Iterator it;
		Collection values;
		String test=null;
		// Javadoc?
		values = loadedFileListsJD.values();
		it = values.iterator();
		while (it.hasNext()&&(test==null)){
			Properties prop = (Properties)it.next();
			test = (String)prop.get(packageAndClass);			
		}
		if (test!=null){
			return JAVADOC_DEFINED;
		}
		// Archive Pool
		values = loadedFileListsAP.values();
		it = values.iterator();
		test=null;
		while (it.hasNext()&&(test==null)){
			Properties prop = (Properties)it.next();
			test = (String)prop.get(packageAndClass);			
		}
		if (test!=null){
			return AP_DEFINED;
		}
		// Usage?
		values = loadedFileListsUS.values();
		it = values.iterator();
		test=null;
		while (it.hasNext()&&(test==null)){
			Properties prop = (Properties)it.next();
			test = (String)prop.get(packageAndClass);			
		}
		if (test!=null){
			return USAGE_DEFINE;
		}
		return 0; 
	}
	
	public boolean isTest(JavaFileArrayTestObject testObject,String packageAndClass){
		String [] codeClasses = testObject.getCodeClassification();
		for (int i = 0; i < codeClasses.length; i++) {
			if ("test".equals(codeClasses[i])) {
				return true;
			}
		}
		return false;
	}

}
