/*
 * Created on Dec 13, 2004
 *
 */
package com.sap.tc.jtools.jlint.javadiff.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

/**
 * @author d034003
 *
 * Handling of all meta info for API-Diff of a nightly build.
 * 
 */
public class APIMetaInfo {

	private APIDiff messageHelper = null; // helper class to put messages into JLin.
	private static HashMap processedClasses=null; // Key: packageAndClass Value: InstanceMetaInfo
	
	public APIMetaInfo(APIDiff tmp, String filename){
		messageHelper = tmp;
		if (processedClasses==null){
			File file = new File(filename);
			try{
				InputStream str = new FileInputStream(file); 
				ObjectInputStream ostr = new ObjectInputStream(str);
				processedClasses = (HashMap)ostr.readObject();
			}
			catch(FileNotFoundException ex){
				processedClasses = new HashMap();
			}
			catch(IOException ex){
				throw new RuntimeException(ex.getMessage());
			}
			catch(ClassNotFoundException ex){
				throw new RuntimeException(ex.getMessage());
			}
		}
	}
	
	/**
	 * store the information that Class is part of an API and has an ancestor.  
	 * @param Class    package and name of class that has an ancestor.
	 * @param ancestor package and name of ancestor (implemented interface or base class)
	 * implementation detail: we store the descendants with each ancestor, as we need them
	 * this way around. 
	 */
	public void addAncestor(String Class, String ancestor){
		InstanceMetaInfo tmp = (InstanceMetaInfo)processedClasses.get(ancestor);
		if (tmp==null){
			tmp = new InstanceMetaInfo();
			processedClasses.put(ancestor,tmp);
		}
		tmp.addDescendant(Class);
	}
	
	public void setAPIFlag(String packageAndClass, boolean isAPI){
	  InstanceMetaInfo old = (InstanceMetaInfo)processedClasses.get(packageAndClass);
	  if (old==null){
		old = new InstanceMetaInfo();
		processedClasses.put(packageAndClass,old);
	  }
	  old.setIsAPI(isAPI);
	}
  
	public void setTestFlag(String packageAndClass, boolean isTest){
	  InstanceMetaInfo old = (InstanceMetaInfo)processedClasses.get(packageAndClass);
	  if (old==null){
		old = new InstanceMetaInfo();
		processedClasses.put(packageAndClass,old);
	  }
	  old.setIsTest(isTest);
	}
  
    private void checkDescendants(String packageAndClass,InstanceMetaInfo value){
    	// make flags for descendants consistent: APIs must not depend on Non-APIs.
    	// APIs must not depend on Testcode.
    	if (value.isAPI()){
    		return; // everything is allowed.
    	}
    	Set descendants = value.getDescendants();
    	if (descendants!=null){
    		Iterator it = descendants.iterator();
    		while (it.hasNext()){
    			String childName = (String)it.next();
    			InstanceMetaInfo child = (InstanceMetaInfo)processedClasses.get(childName);
    			if (child.isAPI()&&value.isNOTApi()){
    				value.setIsRequiredAsAPI(true);
    			}
    			if (child.isAPI()&&value.isTest()){
    				Properties prop = new Properties();
    				prop.put("packageAndClass",childName);
    				prop.put("testClass",packageAndClass);
    				messageHelper.addError("apidiff.27",prop);
    			}
    		}
    	}
    }
    
	public void processAPIFlags(){
	  String packageAndClass;
	  InstanceMetaInfo value;
	  Set keys = processedClasses.keySet();
	  Iterator it = keys.iterator();
	  while (it.hasNext()){
		  packageAndClass = (String)it.next();
		  value = (InstanceMetaInfo)processedClasses.get(packageAndClass);
		  checkDescendants(packageAndClass,value);
	  }
	  it = keys.iterator();
	  while (it.hasNext()){
		  packageAndClass = (String)it.next();
		  value = (InstanceMetaInfo)processedClasses.get(packageAndClass);
		  value.processAPIFlags(packageAndClass,messageHelper);
	  }
	}

	public void saveProcessedClasses(String outputDir){
		// write all info into Obj-File 
		try{
			FileOutputStream out = new FileOutputStream(outputDir+"/ClassesInNewApi.ser");
			ObjectOutputStream out2 = new ObjectOutputStream(out);
			out2.writeObject(processedClasses);
		}
		catch(FileNotFoundException ex){
			throw new RuntimeException(ex.getMessage());
		}
		catch(IOException ex){
			throw new RuntimeException(ex.getMessage());
		}
		// write classnames into .properties file.
		Properties prop = new Properties();
		Iterator it = processedClasses.keySet().iterator();
		String packageAndClass;
		String project;
		InstanceMetaInfo info;
		while (it.hasNext()){
			packageAndClass = (String)it.next();
			info = (InstanceMetaInfo)processedClasses.get(packageAndClass);
			project = info.getProjectName();
			prop.put(packageAndClass,project);
		}
		APIDiffUtil.saveProcessedClasses(outputDir+"/ClassesInNewApi.properties",prop);
	}
	
	
}
