/*
 * Created on Dec 6, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.sap.tc.jtools.jlint.javadiff.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * @author d034003
 * some utility-Methods that can be reused in API Diff.
 *
 */
public class APIDiffUtil {

	public static void saveProcessedClasses(String outputFile, Properties processedClasses){
		File out = new File(outputFile);
		try {
			System.out.println("About to write "+outputFile);
			if (!out.canWrite()){
				out.createNewFile();
			}
			FileOutputStream stream = new FileOutputStream(out);
			processedClasses.store(stream,"");
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			throw new RuntimeException(e.getMessage());
		} catch (IOException e) {
			e.printStackTrace();
			throw new RuntimeException(e.getMessage());
		}	
	}
	
	public static Properties loadProcessedClasses(String name){
		Properties result;
		InputStream in;
		result = new Properties();
		File file = new File(name);
		if (file.canRead()){
			try {
				in = new FileInputStream(file);
				result.load(in);
				System.out.println("loading file "+name);
			} catch (FileNotFoundException e) {
				// must never happen, abort
				e.printStackTrace();
				throw new RuntimeException(e.getMessage());
			} catch (IOException e) {
				e.printStackTrace();
				throw new RuntimeException(e.getMessage());
			}
		}
		else{
			// File is missing. This is OK on the first run. Ignore.
			System.out.println("Ignoring missing file "+name);
		}		
		return result;
	}

}
