/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.urlcontentaccess;

/**
 * If an IO error occurs in the communitation with the content server.
 *
 * @author SAP AG
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/util/api/com/sapportals/wcm/util/urlcontentaccess/URLContentAccessException.java#6
 *      $ Copyright (c) SAP AG 2001-2002
 */
public class URLContentAccessException extends Exception {

  private Exception m_ex;

  private String m_httpErrorMessage;

  private String m_httpErrorCode;

  public URLContentAccessException() {
    super();
  }

  public URLContentAccessException(String msg) {
    super(msg);
  }

  public URLContentAccessException(String msg, String httpErrorCode, String httpErrorMessage) {
    super(msg);
    m_httpErrorMessage = httpErrorMessage;
    m_httpErrorCode = httpErrorCode;
  }

  public URLContentAccessException(String msg, Exception ex) {
    super(msg);
    m_ex = ex;
  }

  public Exception getContainedException() {
    return m_ex;
  }

  public String getHttpErrorMessage() {
    return m_httpErrorMessage;
  }

  public String getHttpErrorCode() {
    return m_httpErrorCode;
  }

}

