/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.urlcontentaccess;
import java.io.InputStream;

import java.util.Properties;

/**
 * This interface provides access to resources that are identified by URLs. In
 * particular it is used to access the SAP content server via HTTP.
 *
 * @author SAP AG
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/util/api/com/sapportals/wcm/util/urlcontentaccess/IURLContentAccess.java#6
 *      $ Copyright (c) SAP AG 2001-2002
 */
public interface IURLContentAccess {

  /**
   * Read the content for a URL resource.
   *
   * @param url A full URL
   * @param useCache If the cache must be used
   * @return Reference to a content object
   * @exception URLContentAccessException Exception raised in failure situation
   */
  IURLContent readContent(String url, boolean useCache)
    throws URLContentAccessException;

  /**
   * Read the content for a URL resource. Note: Content from plug-ins is not
   * cached (parameter <code>useCache</code> has no effect).
   *
   * @param cacheID The key to store/access the content in the cache
   * @param url A full URL
   * @param useCache If the cache must be used
   * @return Reference to a content object
   * @exception URLContentAccessException Exception raised in failure situation
   */
  IURLContent readContent(String cacheID, String url, boolean useCache)
    throws URLContentAccessException;

  /**
   * Store content on a HTTP Server
   *
   * @param url The URL
   * @param data The data to send
   * @param mimeType The content type
   * @param contentLength The content length
   * @param fileName The file name, can be null
   * @param httpHeaders Additional HTTP header, can be null
   * @param fileHeaders File header lines, can be null
   * @param useMimeMultipart true: send a mime multipart POST, false: PUT
   *      request
   * @param user Username for HTTP BASIC authentication, can be null
   * @param pass PAssword for HTTP BASIC authentication, can be null
   * @exception URLContentAccessException Exception raised in failure situation
   */
  public void storeContent(String url, InputStream data, String mimeType, long contentLength,
    String fileName, Properties httpHeaders, Properties fileHeaders, boolean useMimeMultipart,
    String user, String pass)
    throws URLContentAccessException;
}

