/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.urlcontentaccess;
import com.sapportals.wcm.util.content.IContent;

import com.sapportals.wcm.util.mmparser.HeaderFields;

import java.io.InputStream;
import java.io.OutputStream;

/**
 * Contains the data and header information for a resource
 *
 * @author SAP AG
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/util/api/com/sapportals/wcm/util/urlcontentaccess/IURLContent.java#6
 *      $ Copyright (c) SAP AG 2001-2002
 */
public interface IURLContent extends IContent {
  /**
   * Writes the content to the output stream.
   *
   * @param out The stream to write to
   * @exception URLContentAccessException
   */
  public void writeTo(OutputStream out)
    throws URLContentAccessException;

  /**
   * Gets the InputStream for the content.
   *
   * @return The stream to read the data from.
   */
  public InputStream getInputStream();

  /**
   * Returns a collection of the header fields for the content.
   *
   * @return The header collection.
   */
  public HeaderFields getHeader();

  /**
   * Set header fields.
   *
   * @param header The header fields.
   */
  void setHeader(HeaderFields header);

  /**
   * Get the content type from the header fields collection.
   *
   * @return The mime type
   */
  public String getContentType();

  /**
   * Get the size of the content data.
   *
   * @return Size of the content in bytes.
   */
  public long getContentLength();

  /**
   * Returns the URL
   *
   * @return uRL
   */
  public String getURL();

  /**
   * Returns the filename
   *
   * @return filename
   */
  public String getFilename();
}

