/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.urlcontentaccess;

import com.sapportals.wcm.util.mmparser.HeaderFields;
import java.io.IOException;
import java.io.InputStream;

/**
 * Protocol plugin Interface for URLContentAccess <p>
 *
 *
 *
 * @author SAP AG, WCM
 * @see URLContentAccess Copyright (c) SAP AG 2001-2002
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/util/api/com/sapportals/wcm/util/urlcontentaccess/IProtocolPlugin.java#6
 *      $
 */
public interface IProtocolPlugin {

  /**
   * @param url TBD: Description of the incoming method parameter
   * @exception IOException Exception raised in failure situation
   */
  public void init(String url)
    throws IOException;

  /**
   * @return inputStream
   * @exception IOException Exception raised in failure situation
   */
  public InputStream getInputStream()
    throws IOException;

  /**
   * @return headerFields
   * @exception IOException Exception raised in failure situation
   */
  public HeaderFields getHeaderFields()
    throws IOException;
}
