/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.trace;

/**
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Frank Khler
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/util/api/com/sapportals/wcm/util/trace/Tracer.java#6
 *      $
 */

import java.io.*;
import java.lang.*;
import java.text.*;
import java.util.*;

/**
 * TBD: Description of the class.
 */
public abstract class Tracer {

  /**
   * TBD: Description of the class.
   */
  private static class DummyTracer extends Tracer {

    DummyTracer() {
      super();
    }

    protected void writeString(String theString) { }

  }

  protected int itsTraceLevel;
  private static Tracer itsInstance = null;
  private static String itsLineSeparator = null;
  private static int itsLineSeparatorLength = 0;

  public Tracer() {
    itsTraceLevel = 0;
    itsInstance = this;
    itsLineSeparator = System.getProperty("line.separator");
    itsLineSeparatorLength = itsLineSeparator.length();
  }

  public static Tracer getInstance() {
    if (itsInstance == null) {
      new DummyTracer().setTraceThreshold(0);
    }
    return itsInstance;
  }

  public void init(int theThreshold) {
    itsTraceLevel = theThreshold;
  }

  public void setTraceThreshold(int theThreshold) {
    itsTraceLevel = theThreshold;
  }

  public int getTraceThreshold() {
    return itsTraceLevel;
  }

  private String getStackString() {
    Throwable t = new Throwable();
    return getStackString(t);
  }

  private String getStackString(Throwable theException) {
    try {
      StringWriter aStringWriter = new StringWriter(500);
      PrintWriter aPrintWriter = new PrintWriter(aStringWriter);
      theException.printStackTrace(aPrintWriter);
      String aFullString = aStringWriter.toString();
      int aStart = aFullString.indexOf(itsLineSeparator);
      int anEnd = 0;
      while (aStart >= 0 && aFullString.indexOf("Tracer", aStart) >= 0) {
        aStart = aFullString.indexOf(itsLineSeparator, aStart + itsLineSeparatorLength);
      }
      if (aStart >= 0) {
        aStart += itsLineSeparatorLength;
        anEnd = aFullString.length();
        String aFunction = aFullString.substring(aStart, anEnd);
        return aFunction;
      }
      return "";
    }
    catch (Throwable t) {
            //$JL-EXC$      
      return "";
    }
  }

  private String getCallingFunction() {
    try {
      String aStackTrace = getStackString();
      int anEnd = aStackTrace.indexOf(itsLineSeparator);
      if (anEnd >= 0) {
        return aStackTrace.substring(0, anEnd);
      }
      else {
        return aStackTrace;
      }
    }
    catch (Throwable t) {
            //$JL-EXC$      
      return "";
    }
  }

  protected abstract void writeString(String theString);

  public void write(int theTraceLevel, String theText) {
    if (itsTraceLevel >= theTraceLevel) {
      Calendar now = Calendar.getInstance();
      SimpleDateFormat aFormatter = new SimpleDateFormat(" HH:mm:ss.SSS ");
      writeString(Thread.currentThread().getName()
         + aFormatter.format(now.getTime())
         + getCallingFunction() + ": "
         + theText);
    }
  }

  public void write(int theTraceLevel, String theText, Object obj1) {
    if (itsTraceLevel >= theTraceLevel) {
      write(theTraceLevel, theText
         + obj1.toString());
    }
  }

  public void write(int theTraceLevel, String theText, Object obj1, Object obj2) {
    if (itsTraceLevel >= theTraceLevel) {
      write(theTraceLevel, theText
         + obj1.toString()
         + obj2.toString());
    }
  }

  public void write(int theTraceLevel, String theText, Object obj1, Object obj2, Object obj3) {
    if (itsTraceLevel >= theTraceLevel) {
      write(theTraceLevel, theText
         + obj1.toString()
         + obj2.toString()
         + obj3.toString());
    }
  }

  public void write(int theTraceLevel, String theText, Object obj1, Object obj2, Object obj3, Object obj4) {
    if (itsTraceLevel >= theTraceLevel) {
      write(theTraceLevel, theText
         + obj1.toString()
         + obj2.toString()
         + obj3.toString()
         + obj4.toString());
    }
  }

  public void write(int theTraceLevel, String theText, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5) {
    if (itsTraceLevel >= theTraceLevel) {
      write(theTraceLevel, theText
         + obj1.toString()
         + obj2.toString()
         + obj3.toString()
         + obj4.toString()
         + obj5.toString());
    }
  }

  public void write(int theTraceLevel, String theText, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6) {
    if (itsTraceLevel >= theTraceLevel) {
      write(theTraceLevel, theText
         + obj1.toString()
         + obj2.toString()
         + obj3.toString()
         + obj4.toString()
         + obj5.toString()
         + obj6.toString());
    }
  }

  public void write(int theTraceLevel, String theText, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6, Object obj7) {
    if (itsTraceLevel >= theTraceLevel) {
      write(theTraceLevel, theText
         + obj1.toString()
         + obj2.toString()
         + obj3.toString()
         + obj4.toString()
         + obj5.toString()
         + obj6.toString()
         + obj7.toString());
    }
  }

  public void write(int theTraceLevel, String theText, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6, Object obj7, Object obj8) {
    if (itsTraceLevel >= theTraceLevel) {
      write(theTraceLevel, theText
         + obj1.toString()
         + obj2.toString()
         + obj3.toString()
         + obj4.toString()
         + obj5.toString()
         + obj6.toString()
         + obj7.toString()
         + obj8.toString());
    }
  }

  public void write(int theTraceLevel, String theText, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6, Object obj7, Object obj8, Object obj9) {
    if (itsTraceLevel >= theTraceLevel) {
      write(theTraceLevel, theText
         + obj1.toString()
         + obj2.toString()
         + obj3.toString()
         + obj4.toString()
         + obj5.toString()
         + obj6.toString()
         + obj7.toString()
         + obj8.toString()
         + obj9.toString());
    }
  }

  public boolean isLevel(int theTraceLevel) {
    return (itsTraceLevel >= theTraceLevel);
  }

  public void writeStack(int theTraceLevel) {
    if (itsTraceLevel >= theTraceLevel) {
      writeString(getStackString());
    }
  }

  public void writeStack(int theTraceLevel, Throwable theException) {
    if (itsTraceLevel >= theTraceLevel) {
      writeString(getStackString(theException));
    }
  }

  public void writeException(int theTraceLevel, Throwable theException) {
    if (itsTraceLevel >= theTraceLevel) {
      writeString(getStackString(theException) + theException.toString());
    }
  }

}
