/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.monitoring.jarm;

/**
 * Constants for JARM monitoring.
 */
public interface IJarmConst {

  public final static String KM = "EP:KM";
  public final static String DEFAULT_REQUEST_ID = "com.sap.km";
  public final static String DEFAULT_USER_ID = null;
  public final static String KM_CM = KM + ":CM";

  public final static String KM_CM_UI = KM_CM + ":UI";
  public final static String KM_CM_UI_UPLOAD = KM_CM_UI + ":UPLOAD";
  public final static String KM_CM_UI_UPLOAD_COPY = KM_CM_UI_UPLOAD + ":COPY";
  public final static String KM_CM_UI_SENDTO = KM_CM_UI + ":SENDTO";
  public final static String KM_CM_UI_SENDTO_ATTACHMENT = KM_CM_UI_SENDTO + ":ATTACHMENT";
  public final static String KM_CM_UI_SENDTO_SEND = KM_CM_UI_SENDTO + ":SEND";

  public final static String KM_CM_RENDERING = KM_CM + ":RENDERING";
  public final static String KM_CM_RENDERING_PREP = KM_CM_RENDERING + ":PREP";
  public final static String KM_CM_RENDERING_EXEC = KM_CM_RENDERING + ":EXEC";

  public final static String KM_CM_SERVICE = KM_CM + ":SRV";
  public final static String KM_CM_SERVICE_INDEX = KM_CM_SERVICE;
  public final static String KM_CM_SERVICE_INDEX_SEARCH = KM_CM_SERVICE_INDEX + ":SEARCH";
  public final static String KM_CM_SERVICE_INDEX_TEXTMINE = KM_CM_SERVICE_INDEX + ":TEXTMINE";
  public final static String KM_CM_SERVICE_INDEX_CLASSIF = KM_CM_SERVICE_INDEX + ":CLASSIF";
  public final static String KM_CM_SERVICE_ICE = KM_CM_SERVICE + ":ICE";
  public final static String KM_CM_SERVICE_ICE_SEND = KM_CM_SERVICE_ICE + ":SEND";
  public final static String KM_CM_SERVICE_ICE_RECEIVE = KM_CM_SERVICE_ICE + ":RECEIVE";
  public final static String KM_CM_SERVICE_PIPELINE = KM_CM_SERVICE + ":PIPELINE";
  public final static String KM_CM_SERVICE_SUBSCR = KM_CM_SERVICE + ":SUBSCR";
  public final static String KM_CM_SERVICE_SUBSCR_HEVENT = KM_CM_SERVICE_SUBSCR + ":HEVENT";
  public final static String KM_CM_SERVICE_SUBSCR_HPOLL = KM_CM_SERVICE_SUBSCR + ":HPOLL";
  public final static String KM_CM_SERVICE_AIX = KM_CM_SERVICE + ":AINBOX";
  public final static String KM_CM_SERVICE_AIX_DB = KM_CM_SERVICE_AIX + ":DB";

  public final static String KM_CM_PROTOCOL = KM_CM + ":PROTOCOL";
  public final static String KM_CM_PROTOCOL_ICE = KM_CM_PROTOCOL + ":ICE";

  public final static String KM_COLL = KM + ":COLL";
  public final static String KM_COLL_UI = KM_COLL + ":UI";
  public final static String KM_COLL_SERVICE = KM_COLL + "SRV";
  public final static String KM_COLL_SERVICE_ATTACHM = KM_COLL_SERVICE + "ATTACHM";
  public final static String KM_COLL_SERVICE_COMMENT = KM_COLL_SERVICE + "COMMENT";
  public final static String KM_COLL_SERVICE_DISCUS = KM_COLL_SERVICE + "DISCUS";
  public final static String KM_COLL_SERVICE_FEEDBCK = KM_COLL_SERVICE + "FEEDBCK";
  public final static String KM_COLL_SERVICE_PNOTE = KM_COLL_SERVICE + "PNOTE";
  public final static String KM_COLL_SERVICE_RATING = KM_COLL_SERVICE + "RATING";

  public final static String KM_BASE = KM + ":BASE";
  public final static String KM_BASE_CRT = KM_BASE + ":CRT";
  public final static String KM_BASE_SERVICE = KM_BASE + ":SRV";
  public final static String KM_BASE_REPOSITORY = KM_BASE + ":RM";
  public final static String KM_BASE_REPOSITORY_RUNTIME = KM_BASE_REPOSITORY + ":RT";
  public final static String KM_BASE_PROTOCOL = KM_BASE + ":PROTOCOL";
  public final static String KM_BASE_SECURITY = KM_BASE + ":SEC";

}
