/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.mimetypes;

import com.sapportals.config.fwk.Configuration;
import com.sapportals.config.fwk.IConfigClientContext;
import com.sapportals.config.fwk.IConfigManager;
import com.sapportals.config.fwk.IConfigPlugin;
import com.sapportals.config.fwk.IConfigurable;
import com.sapportals.wcm.util.config.ConfigCrutch;
import com.sapportals.wcm.util.uri.RID;
import java.util.ArrayList;
import java.util.Enumeration;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

/**
 * Resource name to mimetype mapping. <p>
 *
 * Copyright (c) SAP AG 2001-2003
 *
 * @author m.breitenfelder@sap.com
 * @author julian.reschke@greenbytes.de
 * @version $Id: MimeTable.java,v 1.3 2003/03/20 18:41:30 jre Exp $
 */

public class MimeTable {
  private final static String CFG_PLUGIN_CM_UTILITIES_MIMES = "/cm/utilities/mimes";
  
  private final static String CFG_MIME_EXTENSION_KEY = "extension";
  private final static String CFG_MIME_TYPE_KEY = "mimetype";
  private final static String DEFAULT_MIME = "application/octet-stream";
  private final static Map mimemap;
  private final static Properties mimeprops;

  private static com.sap.tc.logging.Location log = com.sap.tc.logging.Location.getLocation(com.sapportals.wcm.util.mimetypes.MimeTable.class);

  static {
    Map tmp1 = new HashMap();
    Properties tmp2 = new Properties();

    try {
      IConfigClientContext context = IConfigClientContext.createContext(ConfigCrutch.getConfigServiceUser());
      IConfigManager cfg = Configuration.getInstance().getConfigManager(context);
      IConfigPlugin plugin = cfg.getConfigPlugin(CFG_PLUGIN_CM_UTILITIES_MIMES);
      if (plugin == null) {
        throw new RuntimeException("missing plugin " + CFG_PLUGIN_CM_UTILITIES_MIMES);
      }
      
      IConfigurable[] configurables = plugin.getConfigurables();

      for (int i = 0; i < configurables.length; i++) {
        Properties properties = getConfigurableProperties(configurables[i]);
        String extension = properties.getProperty(CFG_MIME_EXTENSION_KEY);
        String mimetype = properties.getProperty(CFG_MIME_TYPE_KEY);
        if (extension != null && mimetype != null) {
          if (log.beDebug()) {
            log.debugT("<cinit>(62)", "mimetype " + extension + " - " + mimetype);
          }
          tmp1.put(extension.trim().toLowerCase(), mimetype.trim());
          tmp2.put(extension.trim().toLowerCase(), mimetype.trim());
        }
      }
    }
    catch (Exception ex) {
                  //$JL-EXC$
      ex.printStackTrace(System.out);
    }
    finally {
      tmp1.put("", DEFAULT_MIME);
      tmp2.put("", DEFAULT_MIME);

      mimemap = tmp1;
      mimeprops = tmp2;
    }
  }

      
      
  private static Properties getConfigurableProperties(IConfigurable configurable) {
    Properties properties = new Properties();
    Map map = configurable.getProperties(true);
    Iterator i = map.keySet().iterator();
    while (i.hasNext()) {
      Object key = i.next();
      Object value = map.get(key);
      if (value != null) {
        properties.setProperty(key.toString(), value.toString());
      }
    }
    return properties;
  }
  
  private MimeTable() { }


  public static Properties getMimetypes() {
    return mimeprops;
  }


  public static String getMimetypeForExtension(String extension) {
    String type = (String)mimemap.get(extension.toLowerCase());
    return type == null ? DEFAULT_MIME : type;
  }


  public static String[] getExtensionsForMimetype(String mimetype) {
    ArrayList result = new ArrayList();
    if (mimemap.containsValue(mimetype)) {
      Iterator i = mimemap.keySet().iterator();
      while (i.hasNext()) {
        String key = (String)i.next();
        String value = (String)mimemap.get(key);
        if (value != null && value.equals(mimetype)) {
          result.add(key);
        }
      }
    }

    return (String[])result.toArray(new String[result.size()]);
  }


  public static String getMimetypeForRid(RID rid) {
    return getMimetypeForExtension(rid.extension());
  }


  public static String getMimetypeForName(String rid) {
    return getMimetypeForRid(RID.getRID(rid));
  }
}
