package com.sapportals.wcm.util.jdbc.connectionpool;

import javax.servlet.http.*;
/**
 * ONLY FOR INTERNAL USE !!!
 * <p>
 * Copyright (c) SAP AG 2001-2002
 * @author frank.renkes@sap.com
 * @version $Id:$
 */
public class JDBCStatisticCounter {

  private static com.sap.tc.logging.Location log = com.sap.tc.logging.Location.getLocation(JDBCStatisticCounter.class.getName());
	
  private final static String HTTP_KM_LOGON_TIME 				= "km_logon_time";
  private final static String HTTP_KM_SERVER_TIME 			= "km_server_time";
  private final static String HTTP_KM_SERVER_TOTAL_MEM 	= "km_server_total_mem";
  private final static String HTTP_KM_SERVER_FREE_MEM 	= "km_server_free_mem";
  
  // timer when request is started
  private static ThreadLocal srt = new ThreadLocal() {
    protected synchronized Object initialValue() {
      return new Long(0);
    }
  };

  // timer when KM request is started
  private static ThreadLocal skmrt = new ThreadLocal() {
    protected synchronized Object initialValue() {
      return new Long(0);
    }
  };

  synchronized public static void initCounter() {
    srt.set(new Long(System.currentTimeMillis()));
    skmrt.set(new Long(System.currentTimeMillis()));
  }

  public static void startRequestTimer() {
    skmrt.set(new Long(System.currentTimeMillis()));
  }

  public static Long getRequestTimer() {
    return ((Long) (srt.get()));
  }

  public static void write(HttpServletResponse res) {
    Long srt = (Long)JDBCStatisticCounter.getRequestTimer();
    Long skmrt = (Long)JDBCStatisticCounter.getRequestTimer();
    
    if (null != srt) {
      res.setHeader(HTTP_KM_LOGON_TIME, new Long(skmrt.longValue()-srt.longValue()).toString());
      res.setHeader(HTTP_KM_SERVER_TIME, new Long(System.currentTimeMillis()-skmrt.longValue()).toString());
    }

    Runtime rt = Runtime.getRuntime();

    res.setHeader(HTTP_KM_SERVER_FREE_MEM, new Long(rt.freeMemory()).toString());
    res.setHeader(HTTP_KM_SERVER_TOTAL_MEM, new Long(rt.totalMemory()).toString());
  }
}
