/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.jdbc.connectionpool;

import java.sql.*;

/**
 * Wrapper to be able to catch connection problems <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author helmut.cossmann@sap.com
 * @version $Id:$
 */
class JDBCStatementWrapper implements Statement {

  protected final Statement realS;
  protected final Connection conn;

  public JDBCStatementWrapper()
    throws SQLException {
    this.realS = null;
    this.conn = null;
  }

  public JDBCStatementWrapper(Statement realS, JDBCConnectionWrapper conn)
    throws SQLException {
    this.realS = realS;
    this.conn = conn;
  }

  public ResultSet executeQuery(String sql)
    throws SQLException {
    try {
      return this.realS.executeQuery(sql);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public int executeUpdate(String sql)
    throws SQLException {
    try {
      return this.realS.executeUpdate(sql);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void close()
    throws SQLException {
    try {
      this.realS.close();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public int getMaxFieldSize()
    throws SQLException {
    try {
      return this.realS.getMaxFieldSize();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setMaxFieldSize(int max)
    throws SQLException {
    try {
      this.realS.setMaxFieldSize(max);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public int getMaxRows()
    throws SQLException {
    try {
      return this.realS.getMaxRows();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setMaxRows(int max)
    throws SQLException {
    try {
      this.realS.setMaxRows(max);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setEscapeProcessing(boolean enable)
    throws SQLException {
    try {
      this.realS.setEscapeProcessing(enable);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public int getQueryTimeout()
    throws SQLException {
    try {
      return this.realS.getQueryTimeout();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setQueryTimeout(int seconds)
    throws SQLException {
    try {
      this.realS.setQueryTimeout(seconds);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void cancel()
    throws SQLException {
    try {
      this.realS.cancel();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public SQLWarning getWarnings()
    throws SQLException {
    try {
      return this.realS.getWarnings();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void clearWarnings()
    throws SQLException {
    try {
      this.realS.clearWarnings();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setCursorName(String name)
    throws SQLException {
    try {
      this.realS.setCursorName(name);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public boolean execute(String sql)
    throws SQLException {
    try {
      return this.realS.execute(sql);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public ResultSet getResultSet()
    throws SQLException {
    try {
      return this.realS.getResultSet();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public int getUpdateCount()
    throws SQLException {
    try {
      return this.realS.getUpdateCount();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public boolean getMoreResults()
    throws SQLException {
    try {
      return this.realS.getMoreResults();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setFetchDirection(int direction)
    throws SQLException {
    try {
      this.realS.setFetchDirection(direction);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public int getFetchDirection()
    throws SQLException {
    try {
      return this.realS.getFetchDirection();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setFetchSize(int rows)
    throws SQLException {
    try {
      this.realS.setFetchSize(rows);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public int getFetchSize()
    throws SQLException {
    try {
      return this.realS.getFetchSize();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public int getResultSetConcurrency()
    throws SQLException {
    try {
      return this.realS.getResultSetConcurrency();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public int getResultSetType()
    throws SQLException {
    try {
      return this.realS.getResultSetType();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void addBatch(String sql)
    throws SQLException {
    try {
      this.realS.addBatch(sql);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void clearBatch()
    throws SQLException {
    try {
      this.realS.clearBatch();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public int[] executeBatch()
    throws SQLException {
    try {
      return this.realS.executeBatch();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public Connection getConnection()
    throws SQLException {
    try {
      return this.realS.getConnection();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }
}
