/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.jdbc.connectionpool;
import java.math.BigDecimal;

import java.sql.*;
import java.util.Calendar;

/**
 * Wrapper to be able to catch connection problems <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author helmut.cossmann@sap.com
 * @version $Id:$
 */
class JDBCPreparedStatementWrapper extends JDBCStatementWrapper
   implements PreparedStatement {

  public JDBCPreparedStatementWrapper(PreparedStatement realS,
    JDBCConnectionWrapper conn)
    throws SQLException {
    super(realS, conn);
  }

  public ResultSet executeQuery()
    throws SQLException {
    try {
      return ((PreparedStatement)this.realS).executeQuery();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public int executeUpdate()
    throws SQLException {
    try {
      return ((PreparedStatement)this.realS).executeUpdate();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setNull(int parameterIndex, int sqlType)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setNull(parameterIndex, sqlType);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setBoolean(int parameterIndex, boolean x)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setBoolean(parameterIndex, x);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setByte(int parameterIndex, byte x)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setByte(parameterIndex, x);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setShort(int parameterIndex, short x)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setShort(parameterIndex, x);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setInt(int parameterIndex, int x)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setInt(parameterIndex, x);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setLong(int parameterIndex, long x)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setLong(parameterIndex, x);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setFloat(int parameterIndex, float x)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setFloat(parameterIndex, x);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setDouble(int parameterIndex, double x)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setDouble(parameterIndex, x);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setBigDecimal(int parameterIndex, BigDecimal x)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setBigDecimal(parameterIndex, x);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setString(int parameterIndex, String x)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setString(parameterIndex, x);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setBytes(int parameterIndex, byte x[])
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setBytes(parameterIndex, x);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setDate(int parameterIndex, java.sql.Date x)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setDate(parameterIndex, x);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setTime(int parameterIndex, java.sql.Time x)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setTime(parameterIndex, x);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setTimestamp(int parameterIndex, java.sql.Timestamp x)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setTimestamp(parameterIndex, x);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setAsciiStream(int parameterIndex, java.io.InputStream x,
    int length)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setAsciiStream(parameterIndex, x, length);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setUnicodeStream(int parameterIndex, java.io.InputStream x,
    int length)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setUnicodeStream(parameterIndex, x, length);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setBinaryStream(int parameterIndex, java.io.InputStream x,
    int length)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setBinaryStream(parameterIndex, x, length);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void clearParameters()
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).clearParameters();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setObject(int parameterIndex, Object x, int targetSqlType,
    int scale)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setObject(parameterIndex, x, targetSqlType, scale);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setObject(int parameterIndex, Object x, int targetSqlType)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setObject(parameterIndex, x, targetSqlType);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setObject(int parameterIndex, Object x)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setObject(parameterIndex, x);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public boolean execute()
    throws SQLException {
    try {
      return ((PreparedStatement)this.realS).execute();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void addBatch()
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).addBatch();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setCharacterStream(int parameterIndex, java.io.Reader reader,
    int length)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setCharacterStream(parameterIndex, reader, length);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setRef(int i, Ref x)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setRef(i, x);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setBlob(int i, Blob x)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setBlob(i, x);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setClob(int i, Clob x)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setClob(i, x);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setArray(int i, Array x)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setArray(i, x);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public ResultSetMetaData getMetaData()
    throws SQLException {
    try {
      return ((PreparedStatement)this.realS).getMetaData();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setDate(int parameterIndex, java.sql.Date x, Calendar cal)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setDate(parameterIndex, x, cal);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setTime(int parameterIndex, java.sql.Time x, Calendar cal)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setTime(parameterIndex, x, cal);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setTimestamp(int parameterIndex, java.sql.Timestamp x,
    Calendar cal)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setTimestamp(parameterIndex, x, cal);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void setNull(int paramIndex, int sqlType, String typeName)
    throws SQLException {
    try {
      ((PreparedStatement)this.realS).setNull(paramIndex, sqlType, typeName);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }
}
