/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.jdbc.connectionpool;

import com.sap.security.toolkit.login.Credentials;

import com.sapportals.config.fwk.*;
import com.sapportals.portal.security.usermanagement.*;
import com.sapportals.wcm.*;
import com.sapportals.wcm.util.config.*;
import com.sapportals.wcm.util.logging.LoggingFormatter;

import com.sapportals.wcm.util.usermanagement.WPUMFactory;

//for service user security
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.*;
import java.util.*;

/**
 * Manages all pools defined in config <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/util/api/com/sapportals/wcm/util/jdbc/connectionpool/JDBCConnectionPoolManager.java#16
 *      $
 */
public class JDBCConnectionPoolManager {

  private static com.sap.tc.logging.Location log = com.sap.tc.logging.Location.getLocation(com.sapportals.wcm.util.jdbc.connectionpool.JDBCConnectionPoolManager.class);

  private static JDBCConnectionPoolManager instance;
  private JDBCConnectionPool pool;

  private JDBCConnectionPoolManager() {
  }

  public static synchronized JDBCConnectionPoolManager getInstance() {
    if (JDBCConnectionPoolManager.instance == null) {
      JDBCConnectionPoolManager.instance = new JDBCConnectionPoolManager();
    }
    return JDBCConnectionPoolManager.instance;
  }


  /**
   * Returns the instance of an existing pool for the specified Jdbc URL and
   * user name Returns null if a suitable pool was not found.
   *
   * @param id TBD: Description of the incoming method parameter
   * @return pool
   */
  public JDBCConnectionPool getPool(String id) {
    JDBCConnectionPoolManager.log.debugT("getPool() called, id=" + id);    
    if (this.pool == null) {
      try {
        this.pool = new JDBCConnectionPool("");
      }
      catch (WcmException ex) {
        JDBCConnectionPoolManager.log.errorT(LoggingFormatter.extractCallstack(ex));
      }      
    }
    return this.pool;    
  }

  /**
   * Calls release() for all pools
   */
  public synchronized void releaseAll() {
  }

  public synchronized void resetInstance() {
    JDBCConnectionPoolManager.instance = null;
  }

  /**
   * Creates a new pool. see constructor of JDBCConnectionPool
   * @deprecated Since NW04 KMC SP6
   */
  public synchronized JDBCConnectionPool createPool(
    String id,
    String dbDriver,
    String dbUrl,
    String dbUser,
    String dbPass,
    int initConns,
    int maxConns,
    int timeOut,
    int defaultTransactionIsolation,
    boolean defaultAutoCommit,
    boolean cacheCallableStatements,
    String dsName)
    throws WcmException {
      
    JDBCConnectionPoolManager.log.errorT("Someone called createPool(), dsName=" + dsName);
    return new JDBCConnectionPool(dsName);
  }

  public synchronized String[] getPoolIds() {
    //Set ks = JDBCConnectionPoolManager.poolMap.keySet();
    //String[] rv = new String[ks.size()];
    //ks.toArray(rv);
    //return rv;
    return new String[] {};
  }

}
