/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.jdbc.connectionpool;

import com.merant.datadirect.jdbc.extensions.ExtEmbeddedConnection;
import com.sap.tc.logging.Location;

import com.sapportals.wcm.*;
import com.sapportals.wcm.util.logging.LoggingFormatter;
import java.sql.*;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import com.sapportals.wcm.util.opensql.AutoID ;
import java.util.*;

/**
 * This class implements a pool for JDBC Connections. See constructor for
 * connection and configuration options. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/util/api/com/sapportals/wcm/util/jdbc/connectionpool/JDBCConnectionPool.java#22
 *      $
 */
public class JDBCConnectionPool {

  public final static int MSSQL_LOCKTIMEOUT = 10000;

  public final static int DB_UNKNOWN = 0;
  public final static int DB_MSSQL = 1;
  public final static int DB_ORACLE = 2;

  private final static String DRIVER_MSSQL = "com.sap.portals.jdbc.sqlserver.SQLServerDriver";
  private final static String DRIVER_ORACLE = "com.sap.portals.jdbc.oracle.OracleDriver";
  private final static String DRIVER_NAME_OPENSQL = "Open SQL";

  private static com.sap.tc.logging.Location log = com.sap.tc.logging.Location.getLocation(com.sapportals.wcm.util.jdbc.connectionpool.JDBCConnectionPool.class);

  protected final static int NO_DEFAULT_TRANSACTION_ISOLATION = -1;

  private static boolean versionLogged = false;

//  private static Class ddSpyDriverClass;
//  static {
//    try {
//      JDBCConnectionPool.ddSpyDriverClass = Class.forName("com.ddtek.jdbcspy.SpyConnection");
//      if (JDBCConnectionPool.ddSpyDriverClass != null) {
//        JDBCConnectionPool.log.infoT("Datadirect JDBC Spy Driver is loaded");
//      }
//    }
//    catch (Exception ignored) {}
//  }


  private String id;
/*  
  private String dbDriver;
  private String dbUrl;
  private String dbUser;
  private String dbPass;
  private int maxConns;
  private int timeOut;
  private int defaultTransactionIsolation = NO_DEFAULT_TRANSACTION_ISOLATION;
  private boolean defaultAutoCommit;
  private boolean cacheCallableStatements;
*/
  private boolean supportsTransactionIsolation = false;

  private int checkedOutCount;
  private LinkedList connections = new LinkedList();

  private int dbType = JDBCConnectionPool.DB_UNKNOWN;

  //
  private int debug = 0;

  private DataSource dataSource;
  private String dataSourceName;

  private static String scannedDataSourceName = null ;
  /**
  * Creates a new connection pool.
  * @param dataSourceName The name of a datasource configured in the
  * j2ee engine. Will be used also as connection pool ID.
  * @throws WcmException
  */
  public JDBCConnectionPool(String dataSourceName) throws WcmException {
    /* start with alias for engine pool */
    try {
      /*
      * try local j2ee ref lookup first
      */
      this.dataSourceName = "java:comp/env/jdbc/SAP/EP_PRT" ;
      DataSource tds = (DataSource)new InitialContext()
        .lookup ( this.dataSourceName ) ;
    }
    catch ( Exception e ) {
      this.dataSourceName = null ;
    }
    if ( this.dataSourceName == null ) {
      try {
        this.dataSourceName = "jdbc/SAP/EP_PRT" ;
        DataSource tds = (DataSource)new InitialContext()
          .lookup ( this.dataSourceName ) ;
      }
      catch ( Exception e ) {
        this.dataSourceName = null ;
      }
    }
    if ( this.dataSourceName == null ) {
      if ( scannedDataSourceName != null ) {
        this.dataSourceName = scannedDataSourceName ;
      }
      else {
        this.dataSourceName = scanDataSourceNames() ;
        if ( this.dataSourceName != null ) {
          log.errorT ( "JDBCConnectionPool(110)",
            "Using scanned datasource <" + this.dataSourceName
            + "> to retrieve DB connections; called from "
            + com.sapportals.wcm.util.logging.LoggingFormatter
            .extractCallstack ( new Exception())) ;
        }
        scannedDataSourceName = this.dataSourceName ;
      }
    }

    if ( this.dataSourceName == null ) {
      if ( dataSourceName == null ) {
        throw new WcmException("datasource name is null");
      }
      this.dataSourceName = dataSourceName ;
    }
    
    this.id = this.dataSourceName ;
    
    Connection tmpConn = null ;    
    try {
      this.dataSource =
        (DataSource) new InitialContext().lookup(this.dataSourceName);
      AutoID.setDataSourceName ( this.dataSourceName ) ;
    }
    catch (Exception ex) {
      throw new WcmException(ex.getMessage(), ex);
    }
    finally {
      if (tmpConn != null) {
        try {
          tmpConn.close();
        }
        catch (SQLException ex) {
          log.debugT(LoggingFormatter.extractCallstack(ex));
        }
      }
    }
    
    log.debugT("JDBCConnectionPool(110)", "Created pool for datasource: "
      + dataSourceName);
  }

  private String scanDataSourceNames() {
    boolean found = false ;
    char[] cb = new char[13] ;
    String dsnTmpl = "jdbc/SAP___DB" ;
    dsnTmpl.getChars ( 0, dsnTmpl.length(), cb, 0 ) ;
    for ( char c1 = 'A' ; c1 <= 'Z' ; c1++ ) {
      cb[8] = c1 ;
      for ( char c2 = '0' ; c2 <= '9' ; c2++ ) {
        cb[9] = c2 ;
        for ( char c3 = '0' ; c3 <= '9' ; c3++ ) {
          cb[10] = c3 ;
          String _dsn = new String ( cb, 0, 13 ) ;
          try {
            DataSource _ds = (DataSource)new InitialContext().lookup ( _dsn ) ;
            if ( _ds != null ) {
              return ( _dsn ) ;
            }
          }
          catch ( Exception ie ) {
            log.debugT(LoggingFormatter.extractCallstack(ie));
          }
        }
      }
    }
    for ( char c1 = 'A' ; c1 <= 'Z' ; c1++ ) {
      cb[8] = c1 ;
      for ( char c2 = 'A' ; c2 <= 'Z' ; c2++ ) {
        cb[9] = c2 ;
        for ( char c3 = '0' ; c3 <= '9' ; c3++ ) {
          cb[10] = c3 ;
          String _dsn = new String ( cb, 0, 13 ) ;
          try {
            DataSource _ds = (DataSource)new InitialContext().lookup ( _dsn ) ;
            if ( _ds != null ) {
              return ( _dsn ) ;
            }
          }
          catch ( Exception ie ) {
            log.debugT(LoggingFormatter.extractCallstack(ie));            
          }
        }
        for ( char c3 = 'A' ; c3 <= 'Z' ; c3++ ) {
          cb[10] = c3 ;
          String _dsn = new String ( cb, 0, 13 ) ;
          try {
            DataSource _ds = (DataSource)new InitialContext().lookup ( _dsn ) ;
            if ( _ds != null ) {
              return ( _dsn ) ;
            }
          }
          catch ( Exception ie ) {
            log.debugT(LoggingFormatter.extractCallstack(ie));            
          }
        }
      }
      for ( char c2 = '0' ; c2 <= '9' ; c2++ ) {
        cb[9] = c2 ;
        for ( char c3 = 'A' ; c3 <= 'Z' ; c3++ ) {
          cb[10] = c3 ;
          String _dsn = new String ( cb, 0, 13 ) ;
          try {
            DataSource _ds = (DataSource)new InitialContext().lookup ( _dsn ) ;
            if ( _ds != null ) {
              return ( _dsn ) ;
            }
          }
          catch ( Exception ie ) {
            log.debugT(LoggingFormatter.extractCallstack(ie));            
          }
        }
      }
    }
    return null ;
  }


  //////////////////////////////////////////////////////////////////////////////
  // public
  //////////////////////////////////////////////////////////////////////////////

  public String getId() {
    return this.id;
  }

  public String toString() {
    return "JDBCConnectionPool[" + this.id + "]";
  }

  public boolean isInOpenSQLMode() {
    return true;
  }

  /**
   * Get a connection from the pool
   *
   * @return connection
   * @exception SQLException Exception raised in failure situation
   */
  public Connection getConnection() throws SQLException {
    return this.dataSource.getConnection();
  }


  /**
   * Release all connections in the pool
   */
  public synchronized void release() {
    return;
  }


  public void returnCleanConnection(Connection conn)
    throws SQLException {
    conn.close();
  }

  public boolean isDeadlock(SQLException e) {
    throw new UnsupportedOperationException();
  }


  //////////////////////////////////////////////////////////////////////////////
  // protected
  //////////////////////////////////////////////////////////////////////////////


  /**
   * Returns a connection into the pool - called by close() in the connection
   * wrapper
   *
   * @param conn a connection retrieved from the connection pool
   * @param cleanState specifies whether to run cleanup SQL statements on the
   *      connection
   * @param invalidConnection specifies whether any of the statements executed
   *      on the connection threw an exception indicating problems with the
   *      underlying communications channel to the database
   */
  protected synchronized void returnConnection(Connection conn,
    boolean cleanState, boolean invalidConnection) {
  }

  protected synchronized void releaseFinalizedConnection() {
  }

  /**
   * Used by connection wrapper: CallableStatement instances will be cached or
   * not
   *
   * @return cacheCallableStatements
   */
  protected boolean getCacheCallableStatements() {
    return false;
  }

}
