/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.jdbc.connectionpool;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;

import java.sql.*;
import java.util.Calendar;

import java.util.Map;

/**
 * Wrapper that disables the close() method because the connection wrapper
 * caches these instances to be reused by different connection pool users. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Id:$
 */
class JDBCCallableStatementWrapper extends JDBCPreparedStatementWrapper
   implements CallableStatement {

  public JDBCCallableStatementWrapper(CallableStatement realS,
    JDBCConnectionWrapper conn)
    throws SQLException {
    super(realS, conn);
  }

  public void registerOutParameter(int parameterIndex, int sqlType)
    throws SQLException {
    try {
      ((CallableStatement)this.realS).registerOutParameter(parameterIndex, sqlType);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void registerOutParameter(int parameterIndex, int sqlType, int scale)
    throws SQLException {
    try {
      ((CallableStatement)this.realS).registerOutParameter(parameterIndex, sqlType, scale);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public boolean wasNull()
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).wasNull();
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public String getString(int parameterIndex)
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).getString(parameterIndex);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public boolean getBoolean(int parameterIndex)
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).getBoolean(parameterIndex);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public byte getByte(int parameterIndex)
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).getByte(parameterIndex);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public short getShort(int parameterIndex)
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).getShort(parameterIndex);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public int getInt(int parameterIndex)
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).getInt(parameterIndex);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public long getLong(int parameterIndex)
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).getLong(parameterIndex);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public float getFloat(int parameterIndex)
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).getFloat(parameterIndex);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public double getDouble(int parameterIndex)
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).getDouble(parameterIndex);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public BigDecimal getBigDecimal(int parameterIndex, int scale)
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).getBigDecimal(parameterIndex, scale);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public byte[] getBytes(int parameterIndex)
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).getBytes(parameterIndex);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public Date getDate(int parameterIndex)
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).getDate(parameterIndex);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public Time getTime(int parameterIndex)
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).getTime(parameterIndex);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public Timestamp getTimestamp(int parameterIndex)
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).getTimestamp(parameterIndex);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public Object getObject(int parameterIndex)
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).getObject(parameterIndex);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public BigDecimal getBigDecimal(int parameterIndex)
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).getBigDecimal(parameterIndex);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public Object getObject(int i, Map map)
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).getObject(i, map);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public Ref getRef(int i)
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).getRef(i);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public Blob getBlob(int i)
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).getBlob(i);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public Clob getClob(int i)
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).getClob(i);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public Array getArray(int i)
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).getArray(i);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public Date getDate(int parameterIndex, Calendar cal)
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).getDate(parameterIndex, cal);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public Time getTime(int parameterIndex, Calendar cal)
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).getTime(parameterIndex, cal);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public Timestamp getTimestamp(int parameterIndex, Calendar cal)
    throws SQLException {
    try {
      return ((CallableStatement)this.realS).getTimestamp(parameterIndex, cal);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }

  public void registerOutParameter(int paramIndex, int sqlType, String typeName)
    throws SQLException {
    try {
      ((CallableStatement)this.realS).registerOutParameter(paramIndex, sqlType, typeName);
    }
    catch (SQLException e) {
      ((JDBCConnectionWrapper)this.conn).evalException(e);
      throw e;
    }
  }
}
