/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.icons;
import com.sap.tc.logging.Location;

import com.sapportals.config.fwk.*;

import com.sapportals.wcm.*;
import com.sapportals.wcm.util.config.*;
import com.sapportals.wcm.util.logging.LoggingFormatter;
import com.sapportals.wcm.util.uri.URI;

import java.util.*;

/**
 * TBD: Description of the class.
 */
public class IconTable {

  private final static String CFG_PLUGIN_CM_UTILITIES_ICONS = "/cm/utilities/icons";
  
  private final static String CFG_ICONS_MIMETYPE_KEY = "mimetype";
  private final static String CFG_ICONS_IMAGE_KEY = "image";
  private final static String DEFAULT_ICON = "unknown.gif";

  private static com.sap.tc.logging.Location s_log = com.sap.tc.logging.Location.getLocation(com.sapportals.wcm.util.icons.IconTable.class);
  private static Properties s_icons = null;

  static {
    try {
      IConfigClientContext context = IConfigClientContext.createContext(ConfigCrutch.getConfigServiceUser());
      IConfigManager cfg = Configuration.getInstance().getConfigManager(context);
      IConfigPlugin plugin = cfg.getConfigPlugin(CFG_PLUGIN_CM_UTILITIES_ICONS);
      if (plugin == null) {
        throw new RuntimeException("missing plugin " + CFG_PLUGIN_CM_UTILITIES_ICONS);
      }
      
      IConfigurable[] configurables = plugin.getConfigurables();
      s_icons = new Properties();
      for (int i = 0; i < configurables.length; i++) {
        Properties properties = getConfigurableProperties(configurables[i]);
        String mimetype = properties.getProperty(CFG_ICONS_MIMETYPE_KEY);
        String image = properties.getProperty(CFG_ICONS_IMAGE_KEY);
        if (mimetype != null && image != null) {
          if (s_log.beDebug()) {
            s_log.debugT("<cinit>(50)", "icon " + mimetype + " - " + image);
          }
          s_icons.put(mimetype, image);
        }
      }
    }
    catch (Exception ex) {
                  //$JL-EXC$
      ex.printStackTrace(System.out);
    }
  }

  private IconTable() { }

  private static Properties getConfigurableProperties(IConfigurable configurable) {
    Properties properties = new Properties();
    Map map = configurable.getProperties(true);
    Iterator i = map.keySet().iterator();
    while (i.hasNext()) {
      Object key = i.next();
      Object value = map.get(key);
      if (value != null) {
        properties.setProperty(key.toString(), value.toString());
      }
    }
    return properties;
  }
  
  public static Properties getIcons() {
    return s_icons;
  }

  public static String getIconForMimetype(String mimetype) {
    if (s_icons == null) {
      return DEFAULT_ICON;
    }
    String icon = s_icons.getProperty(mimetype.toLowerCase());
    if (icon != null && icon.length() > 0) {
      return icon.trim();
    }
    else {
      return DEFAULT_ICON;
    }
  }
}
