/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.cron;

import com.sapportals.wcm.WcmException;

import java.io.InputStream;
import java.util.Date;

/**
 * The crontab file access interface.
 */
public interface ICrontabData {

  /**
   * Get the name of the crontab file.
   *
   * @return a <code>String</code> with the name or URL of the crontab file.
   */
  public String getName();


  /**
   * Get the input stream for the content of the crontab file.
   *
   * @return an <code>InputStream</code> to read the content of the crontab
   *      file.
   * @exception WcmException Exception raised in failure situation
   */
  public InputStream getInputStream()
    throws WcmException;


  /**
   * Get the last change date of the crontab file.
   *
   * @return a <code>long</code> with the timestamp of the last modification of
   *      the crontab file.
   * @exception WcmException Exception raised in failure situation
   */
  public long lastModified()
    throws WcmException;

}
