/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.cron;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.util.mmparser.HeaderFields;
import com.sapportals.wcm.util.uri.URL;
import com.sapportals.wcm.util.urlcontentaccess.IURLContent;
import com.sapportals.wcm.util.urlcontentaccess.URLContentAccess;

import java.io.InputStream;
import java.util.Date;

/**
 * ICrontabData implementation for URLContent.
 */
public class CrontabDataURL
   implements ICrontabData {

  // ----------------
  // Member Variables ---------------------------------------------------------
  // ----------------

  private URL m_URL;
  private IURLContent m_Content = null;
  private long m_LastModified = 0;


  // -----------
  // Constructor --------------------------------------------------------------
  // -----------

  // ------------------------------------------------------------------------
  public CrontabDataURL(URL url)
    throws WcmException {

    m_URL = url;

    try {
      m_Content = URLContentAccess.getInstance().readContent(url.toString(), true);
    }
    catch (Exception e) {
      throw new WcmException(e);
    }

  }


  // ------------
  // ICrontabData -------------------------------------------------------------
  // ------------

  // ------------------------------------------------------------------------
  public String getName() {

    return m_URL.toString();
  }


  // ------------------------------------------------------------------------
  public InputStream getInputStream()
    throws WcmException {

    if (m_Content == null) {
      throw new WcmException("CrontabDataURL: unable to access " + getName());
    }

    Date now = new Date();
    m_LastModified = now.getTime();

    return m_Content.getInputStream();
  }


  // ------------------------------------------------------------------------
  public long lastModified()
    throws WcmException {

    /**
     * @todo: header fields not working for wcm://...
     */
    /*
     * HeaderFields header = m_Content.getHeader();
     * String timestamp = header.getHeaderField("Last-Modified");
     * try {
     * if( timestamp != null ) {
     * return Long.parseLong(timestamp);
     * }
     * }
     * catch( Exception e ) {
     * }
     */
    return m_LastModified;
  }

}
