/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.cron;

import com.sapportals.wcm.WcmException;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

/**
 * ICrontabData implementation for files.
 */
public class CrontabDataFile
   implements ICrontabData {

  // ----------------
  // Member Variables ---------------------------------------------------------
  // ----------------

  /**
   * the filename for the crontab data.
   */
  private String m_Filename;


  // -----------
  // Constructor --------------------------------------------------------------
  // -----------

  // ------------------------------------------------------------------------
  public CrontabDataFile(String filename) {

    m_Filename = filename;

  }


  // ------------
  // ICrontabData -------------------------------------------------------------
  // ------------

  // ------------------------------------------------------------------------
  public String getName() {

    return m_Filename;
  }


  // ------------------------------------------------------------------------
  public InputStream getInputStream()
    throws WcmException {

    try {
      return new FileInputStream(m_Filename);
    }
    catch (Exception e) {
      throw new WcmException(e);
    }

  }


  // ------------------------------------------------------------------------
  public long lastModified()
    throws WcmException {

    File file = new File(m_Filename);

    return file.lastModified();
  }

}
