/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.cron;
import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.util.trace.*;
import com.sapportals.wcm.util.uri.URL;

/**
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Frank Khler
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/util/api/com/sapportals/wcm/util/cron/Cron.java#6
 *      $
 */

import java.util.*;

/**
 * TBD: Description of the class.
 */
public class Cron {

  Crontab itsCrontab;
  Timer itsTimer;
  Tracer itsTracer;


  private void initialize(ICrontabData theCrontabData,
    boolean theDaemonFlag) {

    itsTracer = Tracer.getInstance();
    itsCrontab = new Crontab(theCrontabData);
    itsCrontab.read();

    // the timer should tick every full minute.
    Calendar now = Calendar.getInstance();
    long aDelay = (60 - now.get(Calendar.SECOND)) * 1000;

    itsTimer = new Timer(theDaemonFlag);
    itsTimer.scheduleAtFixedRate(itsCrontab, aDelay, 60000);

  }


  public Cron(String theFilename) {
    this(theFilename, false);
  }


  public Cron(String theFilename, boolean theDaemonFlag) {
    ICrontabData aDataFile = new CrontabDataFile(theFilename);
    initialize(aDataFile, theDaemonFlag);
  }


  public Cron(URL theURL,
    boolean theDaemonFlag)
    throws WcmException {

    ICrontabData aDataContent = new CrontabDataURL(theURL);

    initialize(aDataContent, theDaemonFlag);

  }


  /**
   * @param theFilename TBD: Description of the incoming method parameter
   * @deprecated as of NW04. Please use <code>read()</code> without parameter instead.
   */
  public void read(String theFilename) {
    read();
  }


  public void read() {
    itsCrontab.read();
  }


  public void executeLatestMatch() {
    Collection aLatestMatchSet = itsCrontab.findLatestMatches();
    Iterator it = aLatestMatchSet.iterator();
    while (it.hasNext()) {
      String aParameter = (String)it.next();
      itsCrontab.callAction(aParameter);
    }
  }


  public void registerRepeatedActionAtBegin(IRepeatedAction theAction, long theFirstRun, long theFrequency, Object theParameter) {
    itsCrontab.registerRepeatedActionAtBegin(theAction, theFirstRun, theFrequency, theParameter);
  }


  public void registerRepeatedAction(IRepeatedAction theAction, long theFirstRun, long theFrequency, Object theParameter) {
    itsCrontab.registerRepeatedAction(theAction, theFirstRun, theFrequency, theParameter);
  }


  public void registerRepeatedActionAtEnd(IRepeatedAction theAction, long theFirstRun, long theFrequency, Object theParameter) {
    itsCrontab.registerRepeatedActionAtEnd(theAction, theFirstRun, theFrequency, theParameter);
  }


  public void deregisterRepeatedAction(IRepeatedAction theAction) {
    itsCrontab.deregisterRepeatedAction(theAction);
  }


  public void stop() {
    itsTimer.cancel();
  }

}
