/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.channels.wcm;
import com.sapportals.wcm.util.channels.IRecipient;

import com.sapportals.wcm.util.channels.IRecipientListIterator;

import java.util.ListIterator;

/**
 * An iterator for a <code>IRecipientList</code> . (see <i>
 * java.util.ListIterator</i> ). <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author paul.goetz@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/api/com/sapportals/wcm/util/channels/wcm/RecipientListIterator.java#2
 *      $
 */
public class RecipientListIterator
   implements IRecipientListIterator {

  // ------------------
  // Instance Variables -------------------------------------------------------
  // ------------------

  private ListIterator m_Iterator;


  // ------------
  // Constructors -------------------------------------------------------------
  // ------------

  // ------------------------------------------------------------------------
  public RecipientListIterator(ListIterator iterator) {

    m_Iterator = iterator;

  }


  // ----------------------
  // IRecipientListIterator ---------------------------------------------------
  // ----------------------

  // ------------------------------------------------------------------------
  public boolean hasNext() {

    return m_Iterator.hasNext();
  }


  // ------------------------------------------------------------------------
  public IRecipient next() {

    return (IRecipient)m_Iterator.next();
  }


  // ------------------------------------------------------------------------
  public boolean hasPrevious() {

    return m_Iterator.hasPrevious();
  }


  // ------------------------------------------------------------------------
  public IRecipient previous() {

    return (IRecipient)m_Iterator.previous();
  }


  // ------------------------------------------------------------------------
  public int nextIndex() {

    return m_Iterator.nextIndex();
  }


  // ------------------------------------------------------------------------
  public int previousIndex() {

    return m_Iterator.previousIndex();
  }


  // ------------------------------------------------------------------------
  public void remove() {

    m_Iterator.remove();

  }


  // ------------------------------------------------------------------------
  public void set(IRecipient recipient) {

    m_Iterator.set(recipient);

  }


  // ------------------------------------------------------------------------
  public void add(IRecipient recipient) {

    m_Iterator.add(recipient);

  }

}
