/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.channels.wcm;

import com.sapportals.wcm.WcmObject;
import com.sapportals.wcm.util.channels.IRecipient;
import com.sapportals.wcm.util.channels.IRecipientList;
import com.sapportals.wcm.util.channels.IRecipientListIterator;
import com.sapportals.wcm.util.channels.RecipientFactory;
import java.lang.Cloneable;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/**
 * A list of <code>IRecipient</code> s. (see <i>java.util.LinkedList</i> ). <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author paul.goetz@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/api/com/sapportals/wcm/util/channels/wcm/RecipientList.java#2
 *      $
 */
public class RecipientList
   extends WcmObject
   implements IRecipientList {

  // ------------------
  // Instance Variables -------------------------------------------------------
  // ------------------

  private LinkedList m_List = null;


  // ------------
  // Constructors -------------------------------------------------------------
  // ------------

  // ------------------------------------------------------------------------
  private RecipientList(LinkedList list) {

    m_List = list;

  }


  // ------------------------------------------------------------------------
  public RecipientList(RecipientList recipientList) {

    m_List = new LinkedList(recipientList.m_List);

  }


  // ------------------------------------------------------------------------
  public RecipientList() {

    m_List = new LinkedList();

  }


  // --------------
  // Public Methods -----------------------------------------------------------
  // --------------

  // ------------------------------------------------------------------------
  public String toString() {

    return m_List.toString();
  }


  // ------------------------------------------------------------------------
  public boolean equals(Object object) {

    if (object == null) {
      return false;
    }

    if (object instanceof RecipientList) {
      RecipientList other = (RecipientList)object;
      return m_List.equals(other.m_List);
    }
    else if (object instanceof IRecipientList) {
      IRecipientList other = (IRecipientList)object;
      if (other.size() != m_List.size()) {
        return false;
      }
      ListIterator iterator = m_List.listIterator();
      while (iterator.hasNext()) {
        IRecipient recipient = (IRecipient)iterator.next();
        if (!other.contains(recipient)) {
          return false;
        }
      }
      return true;
    }

    return false;
  }

  // --------------
  // IRecipientList -----------------------------------------------------------
  // --------------

  // ------------------------------------------------------------------------
  public Collection asCollection() {

    return m_List;
  }


  // ------------------------------------------------------------------------
  public boolean isEmpty() {

    return m_List.isEmpty();
  }


  // ------------------------------------------------------------------------
  public int size() {

    return m_List.size();
  }


  // ------------------------------------------------------------------------
  public boolean contains(IRecipient recipient) {

    return m_List.contains(recipient);
  }


  // ------------------------------------------------------------------------
  public boolean add(IRecipient recipient) {

    return m_List.add(recipient);
  }


  // ------------------------------------------------------------------------
  public boolean remove(IRecipient recipient) {

    return m_List.remove(recipient);
  }


  // ------------------------------------------------------------------------
  public IRecipient get(int index) {

    return (IRecipient)m_List.get(index);
  }


  // ------------------------------------------------------------------------
  public IRecipient set(int index,
    IRecipient recipient) {

    return (IRecipient)m_List.set(index, recipient);
  }


  // ------------------------------------------------------------------------
  public void add(int index,
    IRecipient recipient) {

    m_List.add(index, recipient);

  }


  // ------------------------------------------------------------------------
  public void addLast(IRecipient recipient) {

    m_List.addLast(recipient);

  }


  // ------------------------------------------------------------------------
  public IRecipient remove(int index) {

    return (IRecipient)m_List.remove(index);
  }


  // ------------------------------------------------------------------------
  public int indexOf(IRecipient recipient) {

    return m_List.indexOf(recipient);
  }


  // ------------------------------------------------------------------------
  public int lastIndexOf(IRecipient recipient) {

    return m_List.lastIndexOf(recipient);
  }


  // ------------------------------------------------------------------------
  public IRecipientListIterator listIterator() {

    return new RecipientListIterator(m_List.listIterator());
  }


  // ------------------------------------------------------------------------
  public IRecipientListIterator listIterator(int index) {

    return new RecipientListIterator(m_List.listIterator(index));
  }


  // ------------------------------------------------------------------------
  public IRecipientList subList(int startIndex,
    int stopIndex) {

    return new RecipientList(new LinkedList(m_List.subList(startIndex, stopIndex)));
  }


  // ------------------------------------------------------------------------
  public void sort(Comparator comparator) {

    Collections.sort(m_List, comparator);

  }


  // ------------------------------------------------------------------------
  public IRecipientList expand()
    throws com.sapportals.wcm.WcmException {

    IRecipientList subscribedExpanded = RecipientFactory.getInstance().createRecipientList();

    ListIterator subscribedIterator = m_List.listIterator();
    while (subscribedIterator.hasNext()) {
      IRecipient sub = (IRecipient)subscribedIterator.next();
      if (sub != null) {
        if (sub.isGroup()) {
          IRecipientList subExpanded = sub.getGroupMembers();
          IRecipientListIterator subExpandedIterator = subExpanded.listIterator();
          while (subExpandedIterator.hasNext()) {
            IRecipient subsub = subExpandedIterator.next();
            if (!subscribedExpanded.contains(subsub)) {
              subscribedExpanded.add(subsub);
            }
          }
        }
        else {// add the recipient if it's not already in the list.
          if (!subscribedExpanded.contains(sub)) {
            subscribedExpanded.add(sub);
          }
        }
      }
    }

    return subscribedExpanded;
  }

}
