/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.channels.wcm;

import com.sapportals.portal.security.usermanagement.*;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.util.channels.AbstractChannel;
import com.sapportals.wcm.util.channels.ChannelFactory;
import com.sapportals.wcm.util.channels.IRecipient;
import com.sapportals.wcm.util.usermanagement.WPUMFactory;

import java.lang.String;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import javax.activation.*;
import javax.mail.*;
import javax.mail.internet.*;

/**
 * An <code>IChannel</code> -implementation for emails. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author andreas.heix@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/core/com/sapportals/wcm/util/channels/wcm/NullChannel.java#6
 *      $
 */
public class NullChannel
   extends AbstractChannel {

  // ---------
  // Constants ----------------------------------------------------------------
  // ---------

  /**
   * server name configuration parameter.
   */
  private final static String SERVER_TAG = "server";

  /**
   * user id configuration parameter.
   */
  private final static String USER_TAG = "user";

  /**
   * user's password configuration parameter.
   */
  private final static String PASSWD_TAG = "passwd";

  /**
   * email format configuration parameter.
   */
  private final static String FORMAT_TAG = "format";

  /**
   * email type configuration parameter.
   */
  private final static String MAILTYPE_TAG = "type";

  /**
   * email type SMTP configuration constant.
   */
  private final static String MAILTYPE_SMTP = "smtp";

  /**
   * email type IMAP configuration constant.
   */
  private final static String MAILTYPE_IMAP = "imap";

  // ------------------
  // Instance Variables -------------------------------------------------------
  // ------------------

  private Session m_Session = null;


  // ------------
  // Constructors -------------------------------------------------------------
  // ------------

  /**
   * Create a Null channel with a specific id.
   *
   * @param id TBD: Description of the incoming method parameter
   * @param properties TBD: Description of the incoming method parameter
   * @throws WcmException if the channel can't be created.
   */
  public NullChannel(String id,
    Properties properties)
    throws WcmException {

    super(id, properties);

  }


  // --------
  // IChannel -----------------------------------------------------------------
  // --------

  /**
   * Get the type for this channel.
   *
   * @return <code>String</code> is the channel's type (see ChannelFactory).
   */
  public String getType() {
    return ChannelFactory.NULL_CHANNEL;
  }


  /**
   * Get an empty mime message for this channel.
   *
   * @return an empty <code>MimeMessage</code> for this channel.
   * @throws WcmException if there was an error while creating the
   *      mime message.
   */
  public MimeMessage getEmptyMessage()
    throws WcmException {
    return null;
  }


  /**
   * Get the address for the specified recipient.
   *
   * @param recipient TBD: Description of the incoming method parameter
   * @return <code>String</code> is the address of the given recipient for this
   *      channel.
   * @throws WcmException if the recipient's address for this
   *      channel can't be resolved.
   */
  public String getRecipientAddress(IRecipient recipient)
    throws WcmException {

    //the nullChannel doesn't specify addresses for individual recipients.
    //it is used as a "DEV-0"-like output device.
    return "null-channel";
  }

  /**
   * Send a message via this channel to the given address.
   *
   * @param address TBD: Description of the incoming method parameter
   * @param from TBD: Description of the incoming method parameter
   * @param subject TBD: Description of the incoming method parameter
   * @param messagetext TBD: Description of the incoming method parameter
   * @param type TBD: Description of the incoming method parameter
   * @exception WcmException Exception raised in failure situation
   */
  public void sendTo(String address,
    String from,
    String subject,
    String messagetext,
    String type)
    throws WcmException {
    this.sendTo(address, from, subject, messagetext, type, AbstractChannel.ENCODING);
  }


  /**
   * Send a message via this channel to the given address.
   *
   * @param address TBD: Description of the incoming method parameter
   * @param from TBD: Description of the incoming method parameter
   * @param subject TBD: Description of the incoming method parameter
   * @param messagetext TBD: Description of the incoming method parameter
   * @param type TBD: Description of the incoming method parameter
   * @param encoding TBD: Description of the incoming method parameter
   * @exception WcmException Exception raised in failure situation
   */
  public void sendTo(String address,
    String from,
    String subject,
    String messagetext,
    String type,
    String encoding)
    throws WcmException {

    String sendMessage = "Send message to NULL-Channel for following recipients: " + address;
    _log.infoT("sendTo(199)", sendMessage);

  }


  /**
   * Send a message via this channel to the given address.
   *
   * @param address TBD: Description of the incoming method parameter
   * @param from TBD: Description of the incoming method parameter
   * @param mimemessage TBD: Description of the incoming method parameter
   * @exception WcmException Exception raised in failure situation
   */
  public void sendTo(String address,
    String from,
    MimeMessage mimemessage)
    throws WcmException {

    String addresses[] = {address};
    this.sendTo(addresses, from, mimemessage);
  }


  /**
   * Send a message via this channel to the given addresses.
   *
   * @param addresses TBD: Description of the incoming method parameter
   * @param from TBD: Description of the incoming method parameter
   * @param mimemessage TBD: Description of the incoming method parameter
   * @exception WcmException Exception raised in failure situation
   */
  public void sendTo(String addresses[],
    String from,
    MimeMessage mimemessage)
    throws WcmException {

    StringBuffer buffer = new StringBuffer();
    for (int i = 0; i < addresses.length; i++) {
      buffer.append(addresses[i] + ", ");
    }
    String sendMessage = "Send message to NULL-Channel for following recipients: " + buffer.toString();
    _log.infoT("sendTo(240)", sendMessage);
  }

}
