/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.channels.wcm;

import com.sapportals.wcm.util.channels.IChannel;
import com.sapportals.wcm.util.channels.IChannelListIterator;

import java.util.ListIterator;

/**
 * An <code>IChannelList</code> iterator. (see <i>java.util.ListIterator</i> ).
 * <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author paul.goetz@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/api/com/sapportals/wcm/util/channels/wcm/ChannelListIterator.java#2
 *      $
 * @see java.util.ListIterator
 */
public class ChannelListIterator
   implements IChannelListIterator {

  // ------------------
  // Instance Variables -------------------------------------------------------
  // ------------------

  private ListIterator m_Iterator;


  // ------------
  // Constructors -------------------------------------------------------------
  // ------------

  // ------------------------------------------------------------------------
  public ChannelListIterator(ListIterator iterator) {

    m_Iterator = iterator;

  }


  // ----------------------
  // IChannelListIterator ---------------------------------------------------
  // ----------------------

  // ------------------------------------------------------------------------
  public boolean hasNext() {

    return m_Iterator.hasNext();
  }


  // ------------------------------------------------------------------------
  public IChannel next() {

    return (IChannel)m_Iterator.next();
  }


  // ------------------------------------------------------------------------
  public boolean hasPrevious() {

    return m_Iterator.hasPrevious();
  }


  // ------------------------------------------------------------------------
  public IChannel previous() {

    return (IChannel)m_Iterator.previous();
  }


  // ------------------------------------------------------------------------
  public int nextIndex() {

    return m_Iterator.nextIndex();
  }


  // ------------------------------------------------------------------------
  public int previousIndex() {

    return m_Iterator.previousIndex();
  }


  // ------------------------------------------------------------------------
  public void remove() {

    m_Iterator.remove();

  }


  // ------------------------------------------------------------------------
  public void set(IChannel channel) {

    m_Iterator.set(channel);

  }


  // ------------------------------------------------------------------------
  public void add(IChannel channel) {

    m_Iterator.add(channel);

  }

}
