/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.channels.wcm;

import com.sapportals.wcm.WcmObject;
import com.sapportals.wcm.util.channels.IChannel;
import com.sapportals.wcm.util.channels.IChannelList;
import com.sapportals.wcm.util.channels.IChannelListIterator;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;

/**
 * List of <code>IChannel</code> s. (see <i>java.util.LinkedList</i> ). <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author paul.goetz@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/api/com/sapportals/wcm/util/channels/wcm/ChannelList.java#2
 *      $
 * @see java.util.LinkedList
 */
public class ChannelList
   extends WcmObject
   implements IChannelList {

  // ------------------
  // Instance Variables -------------------------------------------------------
  // ------------------

  private LinkedList m_List = null;


  // ------------
  // Constructors -------------------------------------------------------------
  // ------------

  // ------------------------------------------------------------------------
  private ChannelList(LinkedList list) {

    m_List = list;

  }


  // ------------------------------------------------------------------------
  public ChannelList(ChannelList channelList) {

    m_List = new LinkedList(channelList.m_List);

  }


  // ------------------------------------------------------------------------
  public ChannelList() {

    m_List = new LinkedList();

  }


  // --------------
  // Public Methods -----------------------------------------------------------
  // --------------

  // ------------------------------------------------------------------------
  public String toString() {

    return m_List.toString();
  }


  // --------------
  // IChannelList -----------------------------------------------------------
  // --------------

  // ------------------------------------------------------------------------
  public Collection asCollection() {

    return m_List;
  }


  // ------------------------------------------------------------------------
  public boolean isEmpty() {

    return m_List.isEmpty();
  }


  // ------------------------------------------------------------------------
  public int size() {

    return m_List.size();
  }


  // ------------------------------------------------------------------------
  public boolean contains(IChannel channel) {

    return m_List.contains(channel);
  }


  // ------------------------------------------------------------------------
  public boolean add(IChannel channel) {

    return m_List.add(channel);
  }


  // ------------------------------------------------------------------------
  public boolean remove(IChannel channel) {

    return m_List.remove(channel);
  }


  // ------------------------------------------------------------------------
  public IChannel get(int index) {

    return (IChannel)m_List.get(index);
  }


  // ------------------------------------------------------------------------
  public IChannel set(int index,
    IChannel channel) {

    return (IChannel)m_List.set(index, channel);
  }


  // ------------------------------------------------------------------------
  public void add(int index,
    IChannel channel) {

    m_List.add(index, channel);

  }


  // ------------------------------------------------------------------------
  public void addLast(IChannel channel) {

    m_List.addLast(channel);

  }


  // ------------------------------------------------------------------------
  public IChannel remove(int index) {

    return (IChannel)m_List.remove(index);
  }


  // ------------------------------------------------------------------------
  public int indexOf(IChannel channel) {

    return m_List.indexOf(channel);
  }


  // ------------------------------------------------------------------------
  public int lastIndexOf(IChannel channel) {

    return m_List.lastIndexOf(channel);
  }


  // ------------------------------------------------------------------------
  public IChannelListIterator listIterator() {

    return new ChannelListIterator(m_List.listIterator());
  }


  // ------------------------------------------------------------------------
  public IChannelListIterator listIterator(int index) {

    return new ChannelListIterator(m_List.listIterator(index));
  }


  // ------------------------------------------------------------------------
  public IChannelList subList(int startIndex,
    int stopIndex) {

    return new ChannelList(new LinkedList(m_List.subList(startIndex, stopIndex)));
  }


  // ------------------------------------------------------------------------
  public void sort(Comparator comparator) {

    Collections.sort(m_List, comparator);

  }

}
