/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.cache.persistent;
import java.io.*;

import java.util.*;

/**
 * TBD: Description of the class.
 */
public class SerializablePersistentCacheEntry implements Serializable {
  public Object m_object;
  public long m_timeToLive;
  public long m_expirationTime;
  public boolean m_autoDelay;

  public SerializablePersistentCacheEntry() { }

  public SerializablePersistentCacheEntry(Object object, long timeToLive, long expirationTime, boolean autoDelay) {
    m_object = object;
    m_expirationTime = expirationTime;
    m_timeToLive = timeToLive;
    m_autoDelay = autoDelay;
  }

  public boolean isExpired() {
    return m_expirationTime == 0 ? false : m_expirationTime < new Date().getTime();
  }
}
