/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.cache.persistent;

import com.sapportals.wcm.util.cache.*;

import java.util.Date;

/**
 * TBD: Description of the class.
 */
public class PersistentCacheEntry implements ICacheEntry {
  private String m_key = null;
  private Object m_object = null;
  private long m_timeToLive = 0;// 0: never expires
  private long m_expirationTime = 0;// 0: never expires
  private long m_modificationTime;
  private long m_size;
  private boolean m_autoDelay;

  // -- construct --

  public PersistentCacheEntry(String key, Object object, long timeToLive, long expirationTime, long modificationTime, boolean autoDelay, long size) {
    m_key = key;
    m_object = object;
    m_expirationTime = expirationTime;
    m_timeToLive = timeToLive;
    m_modificationTime = modificationTime;
    m_autoDelay = autoDelay;
    m_size = size;
  }

  // -- interfaces --

  public String getKey() {
    return m_key;
  }

  public Object getObject() {
    return m_object;
  }

  public long getSize() {
    return m_size;
  }

  public long getTimeToLive() {
    return m_timeToLive;
  }

  public long getExpirationTime() {
    return m_expirationTime;
  }

  public long getModificationTime() {
    return m_modificationTime;
  }

  public boolean isExpired() {
    return m_expirationTime == 0 ? false : m_expirationTime < new Date().getTime();
  }

  public boolean isAutoDelaying() {
    return m_autoDelay;
  }
}
