/*
 * Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id$
 * Created on 11.03.2004
 */

package com.sapportals.wcm.util.cache.memory.optimized;

/**
 * Class finding primes.
 */
public class PrimeFinder
{
  public static int findNextPrime(int floor)
  {
    boolean isPrime = false;
    while (!isPrime)
    {
      floor++;
      isPrime = true;
      int sqrt = (int)Math.sqrt(floor);
      for (int i = 2; i <= sqrt; i++)
      {
        if ((floor / i * i) == floor)
        {
          isPrime = false;
        }
      }
    }
    return floor;
  }

  public static int findPrevPrime(int ceil)
  {
    boolean isPrime = false;
    while (!isPrime)
    {
      ceil--;
      isPrime = true;
      int sqrt = (int)Math.sqrt(ceil);
      for (int i = 2; i <= sqrt; i++)
      {
        if ((ceil / i * i) == ceil)
        {
          isPrime = false;
        }
      }
    }
    return ceil;
  }
}
