/*
 * Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id$
 * Created on 09.03.2004
 */

package com.sapportals.wcm.util.cache.memory.optimized;

/**
 * Not multithreading-safe implementation (doesn't need to be) of a data structure
 * used to exchange cache entry data with the cache atomically.
 * 
 * Motivation: When accessing data of a cache entry through the cache, this data can
 * only be queried sequentially from the cache, but since the cache lacks any kind
 * of read consistency (due to performance reasons), you may end up in an inconsistent
 * view of the cache entry. Therefore you could use instances of this class (newly
 * created or reused - it's your responsibility to create and get rid of these instances
 * and not to work on them while the cache works on them) and hand them to the cache and
 * let the cache fill them up in a consistent and synchronized manner.
 */
public class LongKeyMutableMemoryCacheEntry extends LongKeyMemoryCacheEntry
{
  public LongKeyMutableMemoryCacheEntry()
  {
    super();
  }

  public LongKeyMutableMemoryCacheEntry(long key)
  {
    super(key);
  }

  public LongKeyMutableMemoryCacheEntry(
    long key,
    Object value,
    long modification,
    long expiration,
    int timetolive,
    boolean refreshing)
  {
    super(key, value, modification, expiration, timetolive, refreshing);
  }

  public void clearEntry()
  {
    this.key = 0;
    this.value = null;
    this.modification = 0;
    this.expiration = 0;
    this.timetolive = 0;
    this.refreshing = false;
  }

  public void setEntry(long key, Object value, long modification, long expiration, int timetolive, boolean refreshing)
  {
    this.key = key;
    this.value = value;
    this.modification = modification;
    this.expiration = expiration;
    this.timetolive = timetolive;
    this.refreshing = refreshing;
  }

  public void setKey(long key)
  {
    this.key = key;
  }

  public void completeEntry(Object value, long modification, long expiration, int timetolive, boolean refreshing)
  {
    this.value = value;
    this.modification = modification;
    this.expiration = expiration;
    this.timetolive = timetolive;
    this.refreshing = refreshing;
  }
}
