/*
 * Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id$
 * Created on 10.03.2004
 */

package com.sapportals.wcm.util.cache.memory.optimized;

/**
 * Not multithreading-safe implementation of a cache statistic data structure.
 */
public class CacheStatistic
{
  private Object cache;
  private int capacity;
  private int actEntryCount;
  private int maxEntryCount;
  private int putCount;
  private int putUpdateCount;
  private int putNewCount;
  private int putNewDisplacingCount;
  private int putNewAddingCount;
  private int removeCount;
  private int removeHitCount;
  private int removeMissCount;
  private int getCount;
  private int getHitCount;
  private int getHitValidCount;
  private int getHitExpiredCount;
  private int getMissCount;
  private int hashCapacity;
  private int hashPutCount;
  private int hashCollisionPutCount;
  private int hashRemoveCount;
  private int hashCollisionRemoveCount;
  private int hashGetCount;
  private int hashCollisionGetCount;
  private int hashRehashCount;

  public String getStatisticAsString()
  {
    StringBuffer statistic = new StringBuffer("Statistic on ");
    statistic.append(this);
    statistic.append(" of size ");
    statistic.append(capacity);
    statistic.append(": ");
    statistic
      .append(putCount)
      .append(" put() with ")
      .append(putUpdateCount)
      .append(" updated and ")
      .append(putNewCount)
      .append(" new entries (")
      .append(putNewDisplacingCount)
      .append(" displacing and ")
      .append(putNewAddingCount)
      .append(" adding). ");
    statistic
      .append(removeCount)
      .append(" remove() with ")
      .append(removeHitCount)
      .append(" hits and ")
      .append(removeMissCount)
      .append(" misses. ");
    statistic
      .append(getCount)
      .append(" get() with ")
      .append(getHitCount)
      .append(" hits (")
      .append(getHitValidCount)
      .append(" valid and ")
      .append(getHitExpiredCount)
      .append(" expired) and ")
      .append(getMissCount)
      .append(" misses. ");
    statistic
      .append("Hash of size ")
      .append(hashCapacity)
      .append(" handled ")
      .append(getHashPutCount())
      .append(" (")
      .append(getHashCollisionPutCount())
      .append(") put(), ")
      .append(getHashRemoveCount())
      .append(" (")
      .append(getHashCollisionRemoveCount())
      .append(") remove(), ")
      .append(getHashGetCount())
      .append(" (")
      .append(getHashCollisionGetCount())
      .append(") get() and ")
      .append(getHashRehashCount())
      .append(" rehash().");
    return statistic.toString();
  }

  public String getRecommendationsAsString()
  {
    StringBuffer recommendations = new StringBuffer("Recommendations on ");
    recommendations.append(cache);
    recommendations.append(" of size ");
    recommendations.append(capacity);
    recommendations.append(":");
    int length = recommendations.length();

    // Make recommendations
    // TBD: These are just very simple and quick made recommendations; this code could
    // therefore benefit from some more theoretical and practical work in order to help
    // the developer in sizing and using the cache.
    if (getMissCount > getHitCount)
    {
      recommendations.append(" More read misses than hits -> Increase capacity if possible;");
    }

    if ((capacity >> 1) > (putNewAddingCount - removeHitCount - getHitExpiredCount))
    {
      recommendations.append(
        " Less entries than half of capacity -> Increase cache utilization - if the recommendation remains, decrease capacity to safe memory;");
    }
    if (putCount > getCount)
    {
      recommendations.append(
        " More writes than reads -> Increase reads on the cache or decrease unnecessary writes;");
    }
    if (putNewDisplacingCount > getCount)
    {
      recommendations.append(
        " More displacing writes than reads -> Increase reads on the cache or decrease unnecessary writes;");
    }
    if (removeHitCount > (putNewAddingCount >> 1))
    {
      recommendations.append(
        " More than half of all put new operations negated by remove operations -> Check if remove operations are justified;");
    }
    if (removeMissCount > removeHitCount)
    {
      recommendations.append(
        " More remove misses than hits -> Check if remove operations are justified;");
    }
    if (getHitExpiredCount > getHitValidCount)
    {
      recommendations.append(
        " More expired than valid reads -> Check expiration behaviour of cached entries;");
    }
    if ((hashCollisionPutCount > (hashPutCount << 3))
      || (hashCollisionRemoveCount > (hashRemoveCount << 3))
      || (hashCollisionGetCount > (hashGetCount << 3)))
    {
      recommendations.append(
        " More collision resolution than normal -> Change keys to be more randomly distributed;");
    }
    if (hashRehashCount > (hashCollisionRemoveCount << 3))
    {
      recommendations.append(
        " More rehashing than normal -> Change keys to be more randomly distributed;");
    }

    // Check for none and return recommendations
    if (length == recommendations.length())
    {
      recommendations.append(" None.");
    }
    return recommendations.toString();
  }

  /**
   * @return
   */
  public int getActEntryCount()
  {
    return actEntryCount;
  }

  /**
   * @return
   */
  public Object getCache()
  {
    return cache;
  }

  /**
   * @return
   */
  public int getCapacity()
  {
    return capacity;
  }

  /**
   * @return
   */
  public int getGetCount()
  {
    return getCount;
  }

  /**
   * @return
   */
  public int getGetHitCount()
  {
    return getHitCount;
  }

  /**
   * @return
   */
  public int getGetHitExpiredCount()
  {
    return getHitExpiredCount;
  }

  /**
   * @return
   */
  public int getGetHitValidCount()
  {
    return getHitValidCount;
  }

  /**
   * @return
   */
  public int getGetMissCount()
  {
    return getMissCount;
  }

  /**
   * @return
   */
  public int getHashCapacity()
  {
    return hashCapacity;
  }

  /**
   * @return
   */
  public int getHashCollisionGetCount()
  {
    return hashCollisionGetCount;
  }

  /**
   * @return
   */
  public int getHashCollisionPutCount()
  {
    return hashCollisionPutCount;
  }

  /**
   * @return
   */
  public int getHashCollisionRemoveCount()
  {
    return hashCollisionRemoveCount;
  }

  /**
   * @return
   */
  public int getHashGetCount()
  {
    return hashGetCount;
  }

  /**
   * @return
   */
  public int getHashPutCount()
  {
    return hashPutCount;
  }

  /**
   * @return
   */
  public int getHashRehashCount()
  {
    return hashRehashCount;
  }

  /**
   * @return
   */
  public int getHashRemoveCount()
  {
    return hashRemoveCount;
  }

  /**
   * @return
   */
  public int getMaxEntryCount()
  {
    return maxEntryCount;
  }

  /**
   * @return
   */
  public int getPutCount()
  {
    return putCount;
  }

  /**
   * @return
   */
  public int getPutNewAddingCount()
  {
    return putNewAddingCount;
  }

  /**
   * @return
   */
  public int getPutNewCount()
  {
    return putNewCount;
  }

  /**
   * @return
   */
  public int getPutNewDisplacingCount()
  {
    return putNewDisplacingCount;
  }

  /**
   * @return
   */
  public int getPutUpdateCount()
  {
    return putUpdateCount;
  }

  /**
   * @return
   */
  public int getRemoveCount()
  {
    return removeCount;
  }

  /**
   * @return
   */
  public int getRemoveHitCount()
  {
    return removeHitCount;
  }

  /**
   * @return
   */
  public int getRemoveMissCount()
  {
    return removeMissCount;
  }

  /**
   * @param i
   */
  public void setActEntryCount(int i)
  {
    actEntryCount = i;
  }

  /**
   * @param cache
   */
  public void setCache(Object cache)
  {
    this.cache = cache;
  }

  /**
   * @param i
   */
  public void setCapacity(int i)
  {
    capacity = i;
  }

  /**
   * @param i
   */
  public void setGetCount(int i)
  {
    getCount = i;
  }

  /**
   * @param i
   */
  public void setGetHitCount(int i)
  {
    getHitCount = i;
  }

  /**
   * @param i
   */
  public void setGetHitExpiredCount(int i)
  {
    getHitExpiredCount = i;
  }

  /**
   * @param i
   */
  public void setGetHitValidCount(int i)
  {
    getHitValidCount = i;
  }

  /**
   * @param i
   */
  public void setGetMissCount(int i)
  {
    getMissCount = i;
  }

  /**
   * @param i
   */
  public void setHashCapacity(int i)
  {
    hashCapacity = i;
  }

  /**
   * @param i
   */
  public void setHashCollisionGetCount(int i)
  {
    hashCollisionGetCount = i;
  }

  /**
   * @param i
   */
  public void setHashCollisionPutCount(int i)
  {
    hashCollisionPutCount = i;
  }

  /**
   * @param i
   */
  public void setHashCollisionRemoveCount(int i)
  {
    hashCollisionRemoveCount = i;
  }

  /**
   * @param i
   */
  public void setHashGetCount(int i)
  {
    hashGetCount = i;
  }

  /**
   * @param i
   */
  public void setHashPutCount(int i)
  {
    hashPutCount = i;
  }

  /**
   * @param i
   */
  public void setHashRehashCount(int i)
  {
    hashRehashCount = i;
  }

  /**
   * @param i
   */
  public void setHashRemoveCount(int i)
  {
    hashRemoveCount = i;
  }

  /**
   * @param i
   */
  public void setMaxEntryCount(int i)
  {
    maxEntryCount = i;
  }

  /**
   * @param i
   */
  public void setPutCount(int i)
  {
    putCount = i;
  }

  /**
   * @param i
   */
  public void setPutNewAddingCount(int i)
  {
    putNewAddingCount = i;
  }

  /**
   * @param i
   */
  public void setPutNewCount(int i)
  {
    putNewCount = i;
  }

  /**
   * @param i
   */
  public void setPutNewDisplacingCount(int i)
  {
    putNewDisplacingCount = i;
  }

  /**
   * @param i
   */
  public void setPutUpdateCount(int i)
  {
    putUpdateCount = i;
  }

  /**
   * @param i
   */
  public void setRemoveCount(int i)
  {
    removeCount = i;
  }

  /**
   * @param i
   */
  public void setRemoveHitCount(int i)
  {
    removeHitCount = i;
  }

  /**
   * @param i
   */
  public void setRemoveMissCount(int i)
  {
    removeMissCount = i;
  }

  public static final int SIZE = 1000;
  public static final int REP = 10000;
  public static final int READERS = 50;
  public static final int WRITERS = 50;
  public static final boolean TEST_FUNCTION = false;
  public static final boolean TEST_PERFORMANCE = false;
  public static final boolean TEST_THREADING = false;
  public static final boolean TEST_LOCKING = true;
}
