/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.cache.memory;

import com.sapportals.wcm.util.cache.*;
import com.sapportals.wcm.util.cache.memory.optimized.*;

public final class MemoryCacheEntryIndexedByString implements ICacheEntry
{
  private final StringKeyMutableMemoryCacheEntry cacheEntry;

  public MemoryCacheEntryIndexedByString(String key)
  {
    cacheEntry = new StringKeyMutableMemoryCacheEntry(key);
  }

  public MemoryCacheEntryIndexedByString(StringKeyMutableMemoryCacheEntry cacheEntry)
  {
    this.cacheEntry = cacheEntry;
  }

  public StringKeyMutableMemoryCacheEntry getStringKeyMutableMemoryCacheEntry()
  {
    return cacheEntry;
  }

  /* (non-Javadoc)
   * @see com.sapportals.wcm.util.cache.ICacheEntry#getKey()
   */
  public String getKey()
  {
    return cacheEntry.getKey();
  }

  /* (non-Javadoc)
   * @see com.sapportals.wcm.util.cache.ICacheEntry#getObject()
   */
  public Object getObject()
  {
    return cacheEntry.getValue();
  }

  /* (non-Javadoc)
   * @see com.sapportals.wcm.util.cache.ICacheEntry#getSize()
   */
  public long getSize()
  {
    return 0;
  }

  /* (non-Javadoc)
   * @see com.sapportals.wcm.util.cache.ICacheEntry#getTimeToLive()
   */
  public long getTimeToLive()
  {
    return cacheEntry.getTimeToLive();
  }

  /* (non-Javadoc)
   * @see com.sapportals.wcm.util.cache.ICacheEntry#getExpirationTime()
   */
  public long getExpirationTime()
  {
    return cacheEntry.getExpirationTime();
  }

  /* (non-Javadoc)
   * @see com.sapportals.wcm.util.cache.ICacheEntry#getModificationTime()
   */
  public long getModificationTime()
  {
    return cacheEntry.getModificationTime();
  }

  /* (non-Javadoc)
   * @see com.sapportals.wcm.util.cache.ICacheEntry#isExpired()
   */
  public boolean isExpired()
  {
    return cacheEntry.isExpired();
  }

  /* (non-Javadoc)
   * @see com.sapportals.wcm.util.cache.ICacheEntry#isAutoDelaying()
   */
  public boolean isAutoDelaying()
  {
    return cacheEntry.isRefreshing();
  }
}
