/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.acl.jdbc;


import com.sapportals.portal.security.usermanagement.IUMPrincipal;
import com.sapportals.wcm.util.acl.*;


/**
 * Default implementation of an <code>IAclEntryRaw</code>. <br>
 */
public final class JDBCAclEntryRaw
extends JDBCAclEntry
implements IAclEntryRaw {
  
  /**
   * Construct
   */
  public JDBCAclEntryRaw(AbstractDatabaseConnectionUncached databaseConnection,
                         IUMPrincipal principal,
                         boolean negative,
                         IAclPermission permission,
                         int sortIndex,
                         boolean propagate)
                  throws InvalidClassException {
    super(databaseConnection, principal, negative, permission, sortIndex, propagate);
  }


  public JDBCAclEntryRaw(AbstractDatabaseConnectionUncached databaseConnection,
                         IUMPrincipal principal,
                         boolean negative, 
                         JDBCPermission permission, 
                         int sortIndex, 
                         boolean propagate) {
    super(databaseConnection, principal, negative, permission, sortIndex, propagate);
  }

}
