/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 */
package com.sap.tc.cmi.util;

import com.sap.tc.cmi.model.ICMIModelClass;
import com.sap.tc.cmi.util.*;

/**
 * Methods a listener must implement to be informed about list changes.
 * This type can be called, extended or implemented by applications or frameworks using CMI.
 *
 * @SAPCMIPart 1
 * @author Frank Weigel
 * @version $Id: //tc/CommonModelInterface/630_VAL_REL/src/_cmi_api/java/com/sap/tc/cmi/util/ICMIObservableListChangeListener.java#1 $
 */
public interface ICMIObservableListChangeListener {

  /**
   * Event which is fired when a single element is added. </p>
   * 
   * The event object must contain the added element, the index where 
   * the element has been added (as both fromIndex and toIndex) and 
   * the event type must be <code>ELEMENT_ADDED</code>.</p>
   * 
   * This event implies an index change for any existing elements after the
   * inserted element.</p>
   *
   * @param event an event object that describes the added element
   */
  void elementAdded(CMIObservableListEvent event);

  /**
   * Event which is fired when a single element is changed. </p>
   * 
   * Changed means, that the referenced object at an already existing 
   * position in the list has changed without modifying the length of
   * the list. </p>
   * 
   * The event object must contain the changed element (old value, new
   * one can be retrieved from event source), the index where the element 
   * has been changed (as both fromIndex and toIndex) and 
   * the event type must be <code>ELEMENT_CHANGED</code>.</p>
   * 
   * @param event an event object that describes the added element
   */
  void elementChanged(CMIObservableListEvent event);

  /**
   * Event which is fired when a single element has been removed. </p>
   * 
   * The event object must contain the removed element (old value), the 
   * index where the element has been removed (as both fromIndex and toIndex) and 
   * the event type must be <code>ELEMENT_REMOVED</code>.</p>
   * 
   * This change implies an index change for any existing elements after the
   * removed element.</p>
   * 
   * @param event an event object that describes the added element
   */
  void elementRemoved(CMIObservableListEvent event);

  /**
   * Event which is fired when the list has changed in a more complex way.</p>
   * 
   * The event object must at least contain the event type. Depending on the event
   * type, further data can be supplied. See CMIObservableListEvent for details.</p>
   * 
   * @param event an event object that describes the added element
   */
  void complexChange(CMIObservableListEvent event);
  
}
