/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 */
package com.sap.tc.cmi.model;

import java.util.Collection;
import com.sap.tc.cmi.metadata.ICMIModelObjectCollectionInfo;

/**
 * Represents a collection of instances of model classes in a model. 
 * The model classes can be typed or generic and a single collection
 * can contain instances of multiple classes.</p>
 * 
 * Implementing this interface is optional for a model implementation.</p>
 * 
 * Note that without further information, no type other than java.lang.Object 
 * can be assumed for the elements of a model object collection, as typed
 * model classes don't have to implement any specific interface.</p>
 *
 * This type can be called, extended or implemented by applications or frameworks using CMI.
 *
 * @SAPCMIPart 1
 * @author Stephan Ritter, Frank Weigel
 * @version $Id: //tc/CommonModelInterface/630_VAL_REL/src/_cmi_api/java/com/sap/tc/cmi/model/ICMIModelObjectCollection.java#1 $
 */
public interface ICMIModelObjectCollection extends Collection
{
  /**
   * Returns the {@link com.sap.tc.cmi.metadata.ICMIModelObjectCollectionInfo} meta data,
   * describing this model collection. If no such metadata is available, 
   * <code>null</code> must be returned.
   */
  ICMIModelObjectCollectionInfo associatedModelObjectCollectionInfo();

  /**
   * @supplierCardinality 0..1
   * @label /
   * @directed 
   */
  /*# ICMIModelObjectCollectionInfo lnkICMIModelObjectCollectionInfo; */
}
