/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 */
package com.sap.tc.cmi.model;

import com.sap.tc.cmi.exception.CMIException;

/**
 * allows Access to some executable behavior of model classes.
 *
 * Some model classes provide an execution model (such als calling a web service
 * or some other kind of remote method invokation or the execution of a query).
 * Execution is typically used to retrieve model class instances from a backend
 * system or to store changed data in the backend.</p>
 *
 * This type can be called, extended or implemented by applications or frameworks using CMI.
 *
 * @SAPCMIPart 1
 * @author Markus Cherdron, Stephan Ritter
 * @version $Id: //tc/CommonModelInterface/630_VAL_REL/src/_cmi_api/java/com/sap/tc/cmi/model/ICMIModelClassExecutable.java#1 $
 */

public interface ICMIModelClassExecutable
{

  /**
   * executes the Executable
   * @throws CMIException
   */
  public void execute() throws CMIException;

}