/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 */
package com.sap.tc.cmi.model;

import com.sap.tc.cmi.metadata.ICMIModelClassInfo;
/**
 * Represents a Model class in a Model. The Model class could be generic or typed.
 * Note that for typed Models an implementation doesn't have to implement this interface,
 * since frameworks rely on name comventions for typed accessor method in this case also.
 * This type can be called, extended or implemented by applications or frameworks using CMI.
 *
 * @SAPCMIPart 1
 * @author Stephan Ritter, Frank Weigel
 * @version $Id: //tc/CommonModelInterface/630_VAL_REL/src/_cmi_api/java/com/sap/tc/cmi/model/ICMIModelClass.java#1 $
 */
public interface ICMIModelClass
{
  /**
   * Returns the model to which this ModelClass instance is associated.
   *
   * @return ICMIModel of this ModelClass
   */
  public ICMIModel associatedModel();

  /**
   * returns the metadata, i.e. an object of type {@link com.sap.tc.cmi.metadata.ICMIModelClassInfo}, corresponding
   * to this model class. Typed model implementations
   * may return an object of type ICMIModelClassInfo or <code>null</null> here, where
   * each implementation of a generic model (that means each implementation 
   * of {@link ICMIGenericModelClass} has to
   * support this method and must not return <code>null</code>.
   * 
   * @return ICMIModelClassInfo of this ModelClass
   */
  ICMIModelClassInfo associatedModelClassInfo();

  /**
   * @directed
   * @supplierCardinality 0..1 
   * @label /
   */
  /*# ICMIModelClassInfo lnkICMIModelClassInfo; */

}