/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 */
package com.sap.tc.cmi.model;

import com.sap.tc.cmi.metadata.ICMIModelInfo;

/**
 * Manages and contains all Model classes, which together form a Common Model.
 *
 * Provides a factory for ModelClass instances and
 * represents the runtime characteristics of a model.</p>
 *
 * This type can be called, extended or implemented by applications or frameworks using CMI.
 *
 * @SAPCMIPart 1
 * @author Markus Cherdron
 * @version $Id: //tc/CommonModelInterface/630_VAL_REL/src/_cmi_api/java/com/sap/tc/cmi/model/ICMIModel.java#1 $
 */

public interface ICMIModel
{
  /**
   * @clientCardinality 1
   * @supplierCardinality 0..*
   * @label /
   */
  /*# ICMIModelClass lnkICMIModelClass; */

  /**
   * Gets an instance of ICMIModelClass within the scope of the current model.
   * If a model is not able to support this method, it <i>must</i> throw an
   * <code>UnsupportedOperationException</code>.
   *   
   * @param modelClassName the name of the model class. 
   *     The name should be the same, that 
   *     {@link com.sap.tc.cmi.metadata.ICMIModelClassInfo#getName()} returns,
   *     if there is an appropriate ICMModelClassInfo instance.
   * @return an instance of ICMIModelClass with given name.
   * 
   * @throws UnsupportedOperationException method is not supported by this model.
   */
   public ICMIModelClass createModelObject(String modelClassName);

  /**
   * Gets an instance of ICMIModelClass within the scope of the current model
   * If a model is not able to support this method, it <i>must</i> throw an
   * <code>UnsupportedOperationException</code>.
   * @param modelClassClazz the class of the model class.
   * @return an instance of ICMIModelClass for the given class.
   *   
   * @throws UnsupportedOperationException method is not supported by this model.
   */
   public ICMIModelClass createModelObject(Class modelClassClazz);

  /**
   * @directed
   * @supplierCardinality 0..1
   * @label /
   */
  /*# ICMIModelInfo lnkICMIModelInfo; */

  /**
   * returns the modelInfo of this model
   */
  ICMIModelInfo associatedModelInfo();
}