/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 */
package com.sap.tc.cmi.metadata;

/**
 * represents the metadats of a model relation role at runtime
 * This type can be called, extended or implemented by applications or frameworks using CMI.
 *
 * @SAPCMIPart 1
 * @author Markus Cherdron, Stephan Ritter
 * @version $Id: //tc/CommonModelInterface/630_VAL_REL/src/_cmi_api/java/com/sap/tc/cmi/metadata/ICMIRelationRoleInfo.java#1 $
 */
public interface ICMIRelationRoleInfo extends ICMIAbstractInfo {	
	
  /**
   * @directed
   * @clientCardinality 0..*
   * @supplierCardinality 1
   * @supplierRole modelClassInfo
   * @label / 
   */
  /*# ICMIModelClassInfo lnkICMIModelClassInfo; */

  /**
   * returns the model class info of the model class, to which the role belongs
   */
  ICMIModelClassInfo getModelClassInfo();

  /**
   * @supplierRole sourceRole
   * @supplierCardinality 1
   * @clientCardinality 1
   * @clientRole targetRole
   * @label /*/
  /*# ICMIRelationRoleInfo lnkICMIRelationRoleInfo; */

  /**
   * returns the other role. If <code>this</code> is the source role info,
   * the target role info is returned and vice versa.
   * An implementation can derive this information from the corresponding
   * relation info or from a source role : target role association.
   */
  ICMIRelationRoleInfo getOtherRoleInfo();

  /**
   * returns the corresponing relation info or null, if this method is not supported.
   * So model implementations, which have difficulties to supply relation info,can
   * implement this method with <code>return null;</code>
   */
  ICMIRelationInfo getModelRelationInfo();

  /**
   * returns the cardinality of the role according the defined CARDINALITY... constants.
   * 
   * @see CMICardinality
   */
  CMICardinality getCardinality();

  /**
   * returns <code>true</code>, if role is read only and can not be modified at runtime
   * by a Web Dynpro component or the framework.
   */
  boolean isReadOnly();

  /**
   * returns <code>true</code>, if role is a aggregating role
   */
  boolean isAggregation();

  /**
   * returns <code>true</code>, if role is navigable
   */
  boolean isNavigable();
}