/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 */
package com.sap.tc.cmi.metadata;

import java.util.Collection;
import java.util.Map;

/**
 * Represents an common super interface for runtime meta data of a
 * model element. It is therefore extended by ICMIModelInfo, ICMIModelClassInfo,
 * ICMIModelClassPropertyInfo, ICMIRelationInfo and ICMIRelationRoleInfo.
 * This type can be called, extendeded or implemented by applications or frameworks using CMI.
 *
 * @SAPCMIPart 1
 * @author Markus Cherdron, Stephan Ritter
 * @version $Id: //tc/CommonModelInterface/630_VAL_REL/src/_cmi_api/java/com/sap/tc/cmi/metadata/ICMIAbstractInfo.java#1 $

 * @see ICMIModelInfo
 * @see ICMIModelClassInfo
 * @see ICMIModelClassPropertyInfo 
 * @see ICMIRelationInfo
 * @see ICMIRelationRoleInfo
 */
public interface ICMIAbstractInfo {
  /**
   * @supplierCardinality 0..*
   * @label /
   * @directed*/
  /*# CMISetting lnkCMISetting; */

  /**
   * returns the name of the metadata entity.
   */
  String getName();

  /**
   * returns the setting of the given <code>settingDef</code>.
   */
  CMISetting getSetting(CMISettingDefinition settingDef);

  /**
   * set the setting of the given <code>settingDef</code> to the given <code>value</code>.
   */
  void setSetting(CMISettingDefinition settingDef, String value);

  /**
   * returns a map with all actual settings.
   * The map must be immutable.
   */
  Map getSettings();

  /**
   * returns true, if the given option is supported by the model element
   */
  boolean supports(String option);

  /**
   * returns a collection of all supported options.
   * The collection must be immutable.
   */
  Collection supportedOptions();

  /**
   * adds <code>option</code> to the supported options of the model element.
   */
  void addSupportedOption(String option);

}
