/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 */
package com.sap.tc.cmi.metadata;

/**
 * Instances of this Enumeration Class represent 
 * a setting definition that the metadata of a model element (like {@link ICMIModelInfo}, 
 * {@link ICMIModelClassInfo}, {@link ICMIModelClassPropertyInfo}, {@link ICMIRelationInfo} or 
 * {@link ICMIRelationRoleInfo}) can have. <p>
 * Model implementations can subclass <code>CMISettingDefinition</code> and create their own
 * enumeration of instances as appropriate via {@link #CMISettingDefinition(String settingDef)}.
 * 
 * Then the corresponding {@link CMISetting} instances can be created
 * via {@link ICMIAbstractInfo#setSetting(CMISettingDefinition settingDef, String value)} and 
 * can be retrieved them via {@link ICMIAbstractInfo#getSetting(CMISettingDefinition settingDef)} or
 * via {@link ICMIAbstractInfo#getSettings()}.
 * 
 * This type can be called or extended by applications or frameworks using CMI.
 * 
 * @SAPCMIPart 1 
 * @author Markus Cherdron
 * @version $Id: //tc/CommonModelInterface/630_VAL_REL/src/_cmi_api/java/com/sap/tc/cmi/metadata/CMISettingDefinition.java#1 $
 */
public class CMISettingDefinition
{
    private String settingDef;

    /**
     * protected constructor
     */
    protected CMISettingDefinition(String settingDef)
    {
      this.settingDef = settingDef;
    }

    /**
     * returns the CMISettingDefinition as String
     */
    public String toString()
    {
      return settingDef;
    }

}
