/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 */
package com.sap.tc.cmi.metadata;

/**
 * Describes the cardinality of a relation role.
 * This type can be called by applications or frameworks using CMI, but DO NOT EXTEND IT!
 * 
 * @SAPCMIPart 2 
 * @TODO make class final
 * @author Stephan Ritter
 * @version $Id: //tc/CommonModelInterface/630_VAL_REL/src/_cmi_api/java/com/sap/tc/cmi/metadata/CMICardinality.java#1 $
 */
public class CMICardinality  {
  
  /**
   * constant for the role cardinality 0..1
   */
  public static final CMICardinality CARDINALITY_ZERO_TO_ONE = new CMICardinality(false, false);

  /**
   * constant for the role cardinality * (== 0..* == 0..n)
   */
  public static final CMICardinality CARDINALITY_MANY        = new CMICardinality(false, true);
  
  /**
   * constant for the role cardinality 1 (== 1..1)
   */
  public static final CMICardinality CARDINALITY_ONE         = new CMICardinality(true, false);

  /**
   * constant for the role cardinality 1..* (== 1..n)
   */
  public static final CMICardinality CARDINALITY_ONE_TO_MANY = new CMICardinality(true, true);

  private boolean isMandatory;  
  
  private boolean isMultiple;

  /**
   * private constructor
   */
  private CMICardinality(boolean isMandatory, boolean isMultiple) {
    this.isMandatory = isMandatory;
    this.isMultiple = isMultiple;
  }    

  /**
   * returns true, if the role cardinality is 1 or 1..*
   */  
  public boolean isMandatory() {
    return isMandatory;
  }    
  
  /**
   * returns true, if the role cardinality is * or 1..*
   */  
  public boolean isMultiple() {
    return isMultiple;
  }
  
  /**
   * returns a String representation of the cardinality
   */ 
  public String toString() {
    if (isMandatory()) {
      if (isMultiple()) {
        return new String("1..n");     
      }
      else {
        return new String("1");     
      }    
    }
    else {
      if (isMultiple()) {
        return new String("0..n");     
      }
      else {
        return new String("0..1");     
      }    
    }
  }      
}
