/*
 * Created on Oct 10, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package com.sap.caf.rt.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

import com.sap.security.api.IGroup;
import com.sap.security.api.IGroupFactory;
import com.sap.security.api.IGroupSearchFilter;
import com.sap.security.api.IPrincipal;
import com.sap.security.api.IPrincipalFactory;
import com.sap.security.api.IPrincipalSearchFilter;
import com.sap.security.api.IRole;
import com.sap.security.api.IRoleFactory;
import com.sap.security.api.IRoleSearchFilter;
import com.sap.security.api.ISearchAttribute;
import com.sap.security.api.ISearchResult;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.IUserSearchFilter;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;

/**
 * @author Viachaslav_Vdavichen
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class PrincipalUtils {
	// TODO May be it is common aproach to search principals 

	private static final com.sap.tc.logging.Location logger =
		com.sap.tc.logging.Location.getLocation(PrincipalUtils.class);

	/**
	 * @deprecated Use searchPrincipal(userName, useAsterisk, 0) instead 
	 */
	public static IPrincipal[] searchPrincipal(String searchStr, String type) throws UMException {
		return searchPrincipal(searchStr, type, 0);
	}
	
	public static IPrincipal[] searchPrincipal(String searchStr, String type, int limit) throws UMException {
		IPrincipal[] result = null;
		if (searchStr != null && searchStr.length() > 0) {
			if (IPrincipalFactory.IUSER.equals(type)) {
				result = getUsers(searchStr, false, limit);
			} else if (IPrincipalFactory.IGROUP.equals(type)) {
				result = getGroups(searchStr, false, limit);
			} else if (IPrincipalFactory.IROLE.equals(type)) {
				result = getRoles(searchStr, false, limit);
			} else {
				throw new UMException("unknown type:" + type);
			}
		}
		return result;
	}

	private static IPrincipal[] convertToArray(ISearchResult searchResult) throws UMException {
		IPrincipal[] principals = new IPrincipal[searchResult.size()];
		for (int i = 0; searchResult.hasNext(); i++) {
			principals[i] = UMFactory.getPrincipalFactory().getPrincipal((String) searchResult.next());
		}
		return principals;
	}

	private static IPrincipal[] getGroups(String searchName, boolean useAsterisk, int limit) throws UMException {
		IGroupFactory factory = UMFactory.getGroupFactory();
		try {
			IGroup group = factory.getGroupByUniqueName(searchName);
			return new IGroup[] { group };
		} catch (UMException e) {
			logger.infoT("No group with exactly name {0}", new Object[] { searchName });
			logger.throwing(e);
		}

		IGroupSearchFilter filter = factory.getGroupSearchFilter();
		
		if (limit > 0) {
			filter.setMaxSearchResultSize(limit);
		}
		
		String nameWithAsteric = getStrWithAsterisk(searchName, useAsterisk);
		int operatorToUse = getOperatorByString(nameWithAsteric);
		filter.setUniqueName(nameWithAsteric, operatorToUse, false);
		logger.debugT("filter:" + filter);
		ISearchResult result = factory.searchGroups(filter);
		logger.debugT("Search result:" + result.size());
		if (result.size() > 0) {
			return convertToArray(result);
		}

		filter.clear();

		if (limit > 0) {
			filter.setMaxSearchResultSize(limit);
		}
		
		filter.setDisplayName(nameWithAsteric, operatorToUse, false);
		logger.debugT("filter:" + filter);
		result = factory.searchGroups(filter);
		logger.debugT("Search result:" + result.size());
		if (result.size() > 0) {
			return convertToArray(result);
		}
		return null;
	}

	private static IPrincipal[] getRoles(String searchName, boolean useAsterisk, int limit) throws UMException {
		IRoleFactory factory = UMFactory.getRoleFactory();
		try {
			IRole role = factory.getRoleByUniqueName(searchName);
			return new IRole[] { role };
		} catch (UMException e) {
			logger.infoT("No role with exactly name {0}", new Object[] { searchName });
			logger.throwing(e);
		}

		IRoleSearchFilter filter = factory.getRoleSearchFilter();
		
		if (limit > 0) {
			filter.setMaxSearchResultSize(limit);
		}
		
		filter.setUniqueName(getStrWithAsterisk(searchName, useAsterisk), ISearchAttribute.LIKE_OPERATOR, false);
		logger.debugT("filter:" + filter);
		ISearchResult result = factory.searchRoles(filter);
		logger.debugT("Search result:" + result.size());
		if (result.size() > 0) {
			return convertToArray(result);
		}

		filter.clear();

		if (limit > 0) {
			filter.setMaxSearchResultSize(limit);
		}
		
		filter.setDisplayName(getStrWithAsterisk(searchName, useAsterisk), ISearchAttribute.LIKE_OPERATOR, false);
		logger.debugT("filter:" + filter);
		result = factory.searchRoles(filter);
		logger.debugT("Search result:" + result.size());
		if (result.size() > 0) {
			return convertToArray(result);
		}
		return null;
	}
	
	/**
	 * @deprecated Use getUsers(userName, useAsterisk, 0) instead 
	 */
	public static IUser[] getUsers(String userName, boolean useAsterisk) throws UMException {
		return getUsers(userName, useAsterisk, 0);
	}
	
	public static IUser[] getUsers(String userName, boolean useAsterisk, int limit) throws UMException {
		if (userName == null) {
			return null;
		}
		//exact search by userID
		IUserFactory userFactory = UMFactory.getUserFactory();
		try {
			IUser user = userFactory.getUserByUniqueName(userName);
			return new IUser[] { user };
		} catch (UMException e) {
			logger.infoT("No user with exactly name {0}", new Object[] { userName });
			logger.throwing(e);
		}
		//like search by userLogin
		HashSet resultSet = new HashSet();
		IUserSearchFilter filter = userFactory.getUserSearchFilter();
		
		if (limit > 0) {
			filter.setMaxSearchResultSize(limit);
		}
		
		String userNameWithAsterisk = getStrWithAsterisk(userName, useAsterisk);
		filter.setUniqueName(userNameWithAsterisk, ISearchAttribute.LIKE_OPERATOR, false);
		logger.debugT("filter:" + filter);
		ISearchResult result = userFactory.searchUsers(filter);
		logger.debugT("Search result:" + result.size());
		if (result.size() > 0) {
			for (int i = 0; result.hasNext(); i++) {
				resultSet.add((String) result.next());
			}
		}
		//like search by firstName
		filter.clear();

		if (limit > 0) {
			filter.setMaxSearchResultSize(limit);
		}
		
		filter.setFirstName(userNameWithAsterisk, ISearchAttribute.LIKE_OPERATOR, false);
		logger.debugT("filter:" + filter);
		result = userFactory.searchUsers(filter);
		logger.debugT("Search result:" + result.size());
		if (result.size() > 0) {
			for (int i = 0; result.hasNext(); i++) {
				resultSet.add((String) result.next());
			}
		}
		//like search by lastName
		filter.clear();

		if (limit > 0) {
			filter.setMaxSearchResultSize(limit);
		}
		
		filter.setLastName(userNameWithAsterisk, ISearchAttribute.LIKE_OPERATOR, false);
		logger.debugT("filter:" + filter);
		result = userFactory.searchUsers(filter);
		logger.debugT("Search result:" + result.size());
		if (result.size() > 0) {
			for (int i = 0; result.hasNext(); i++) {
				resultSet.add((String) result.next());
			}
		}
		//like search by firstName and LastName
		filter.clear();

		// commented out as search with more then one attribute is not supported with limit in kw06
		filter.setMaxSearchResultSize(0);
		/*
		if (limit > 0) {
			filter.setMaxSearchResultSize(limit);
		}
		*/
		
		String firstName = getFirstName(userName);
		if (firstName.length() > 0) {
			filter.setFirstName(getStrWithAsterisk(firstName, useAsterisk), ISearchAttribute.LIKE_OPERATOR, false);
		}
		String lastName = getLastName(userName);
		if (lastName.length() > 0) {
			filter.setLastName(getStrWithAsterisk(lastName, useAsterisk), ISearchAttribute.LIKE_OPERATOR, false);
		}
		filter.setSearchMethod(IPrincipalSearchFilter.SEARCHMETHOD_AND);
		logger.debugT("filter:" + filter);
		result = userFactory.searchUsers(filter);
		logger.debugT("Search result:" + result.size());
		if (result.size() > 0) {
			for (int i = 0; result.hasNext(); i++) {
				resultSet.add((String) result.next());				
			}
		}
		//parsing results
		if (resultSet.isEmpty()) {
			return null;	
		}
		IUser[] resultArray = new IUser[resultSet.size()];
		int i = 0;
		for (Iterator iter = resultSet.iterator(); iter.hasNext(); i++) {
			resultArray[i] = userFactory.getUser((String) iter.next());
		}
		return resultArray;
	}

	private static String getFirstName(String name) {
		name = name.trim();
		String result;
		int commaIndex = name.indexOf(COMMA_DELIMITER);
		if (commaIndex >= 0) {
			result = name.substring(commaIndex + 1);
		} else {
			int spaceIndex = name.lastIndexOf(SPACE_DELIMITER);
			if (spaceIndex >= 0) {
				result = name.substring(0, spaceIndex);
			} else {
				result = "";
			}
		}
		return result.trim();
	}

	/**
	 * Examples: 
	 * 		name 		lastName
	 * 		Ax,B		B
	 * 		B A			A
	 * 		C			C
	 * 		,X			<empty>
	 */
	private static String getLastName(String name) {
		name = name.trim();
		String result;
		int commaIndex = name.indexOf(COMMA_DELIMITER);
		if (commaIndex >= 0) {
			result = name.substring(0, commaIndex);
		} else {
			int spaceIndex = name.lastIndexOf(SPACE_DELIMITER);
			if (spaceIndex >= 0) {
				result = name.substring(spaceIndex + 1);
			} else {
				result = name;
			}
		}
		return result.trim();
	}

	private static final String getStrWithAsterisk(String str, boolean useAsterisk) {
		return (useAsterisk && !str.endsWith("*")) ? str + "*" : str;
	}
	
	private static final int getOperatorByString(String name) {
		//groups search needs different operators to be used   
		boolean isExactSearch = (name.indexOf('*') < 0) && (name.indexOf('?') < 0);
		return (isExactSearch) ? ISearchAttribute.EQUALS_OPERATOR : ISearchAttribute.LIKE_OPERATOR;
	}
	/**
	 * Parse semicolon separated string <code>principalIDs</code> into list of principal IDs.
	 */	
	public static List parsePrincipalIDs(String principalIDs) {
		List principals = null;
		if (principalIDs==null || principalIDs.length()==0) {
			principals = Collections.EMPTY_LIST;  
		} else {
			principals = new ArrayList();
			int index1 = principalIDs.indexOf(';');
			while(index1 > 0) {
				principals.add(principalIDs.substring(0, index1));
				principalIDs = principalIDs.substring(index1 + 1);
				index1 = principalIDs.indexOf(';');
			}
			if (principalIDs.length()>0) {
				principals.add(principalIDs);
			}
		}
		return principals;
	}
	
	
	private static final char COMMA_DELIMITER = ',';
	private static final char SPACE_DELIMITER = ' ';
	public static final char PRINCIPAL_DELIMITER = ';';
	
	//@@end
}
