/*
 * Created on 08.04.2004
 *
 */
package com.sap.caf.rt.ui.cool.metadata;


import com.sap.tc.col.client.metadata.api.*;

/**
 * @author Sergey_Firsov
 * Describes the properties of an value set of an aspect field. 
 *
 */
public class ValueSetDescriptor extends AbstractDescriptor
    implements IValueSetDescriptor{
    private AspectDescriptor mAspectDescriptor;
    private FieldDescriptor mFieldDescriptor;
    private StructureDescriptor mInputParameterStructure;
    private StructureDescriptor mOutputTableStructure;

    /**
	 * empty constructor
	 */
	public ValueSetDescriptor(){
    }

    /**
	 * @param name - name of ValueSetDescriptor
	 * @param aspect - AspectDescriptor for this ValueSetDescriptor
	 * @param field - FieldDescriptor for this ValueSetDescriptor
	 * @param inputParameterStructure - StructureDescriptor for input parameters for this ValueSetDescriptor
	 * @param outputTableStructure - StructureDescriptor for output parameters for this ValueSetDescriptor
	 */
	 public ValueSetDescriptor(String name, AspectDescriptor aspect, FieldDescriptor field, StructureDescriptor inputParameterStructure, StructureDescriptor outputTableStructure)
    {
        super(name);
        mAspectDescriptor = aspect;
        mFieldDescriptor = field;
        mInputParameterStructure = inputParameterStructure;
        mOutputTableStructure = outputTableStructure;
        mAspectDescriptor.setValueSetDescriptor(mFieldDescriptor.getName(), this);
    }

    /**
	 * Returns the descriptor of the aspect of this value set
	 */
	 public IAspectDescriptor getAspectDescriptor()
    {
        return mAspectDescriptor;
    }

    /**
	 * Returns the descriptor of the field of this value set
	 */
	 public IFieldDescriptor getFieldDescriptor()
    {
        return mFieldDescriptor;
    }

    /**
	 * Returns the descriptor of the result structure of this value set
	 */
	 public IStructureDescriptor getResultStructureDescriptor()
    {
        return mOutputTableStructure;
    }

    /**
	 * Returns whether the value set has inputParameters
	 */
	 public boolean hasInputParameters()
    {
        return mInputParameterStructure != null;
    }

    /**
	 * Returns the input parameters for this value set.
	 */
	 public IStructureDescriptor getInputParameters()
    {
        return mInputParameterStructure;
    }

}
