package com.sap.caf.rt.ui.cool.metadata;

import java.util.Locale;
import java.util.Map;
import java.util.Set;

import com.sap.caf.rt.services.serviceaccess.ITypedFieldService;
import com.sap.tc.logging.Location;
import com.sap.typeservices.IModifiableSimpleValueSet;
import com.sap.typeservices.ISimpleValueSet;
import com.sap.typeservices.ModifiableSimpleValueSet;

/**
 * @author Alexey_Bloudov
 */

public class TypedFieldService implements ITypedFieldService {
	private String m_type;
	private Locale m_locale;
	private ModifiableSimpleValueSet m_valueSet;

	public TypedFieldService(String type, Locale locale , ModifiableSimpleValueSet valueSet ) {
		m_type = type;
		m_locale = locale;
		if (m_locale == null) {
			m_locale = Locale.getDefault();
		}
		m_valueSet = valueSet;
	}

	/**
	 * @deprecated
	 */
	public ISimpleValueSet getValues(Locale locale) {
		return getModifiableSimpleValueSet();
	}

	public ISimpleValueSet getValues() {
		return getValues(m_locale);
	}

	public boolean validate(String value) {
		return getValues().containsKey(value);
	}

	public boolean validate(Object value) {
		return getValues().containsKey(value);
	}

	public Locale getLocale() {
		return m_locale;
	}

	public IModifiableSimpleValueSet getModifiableSimpleValueSet() {
		return m_valueSet;
	}

	public void setLocale(Locale loc) {
		if (loc != null && !loc.equals(m_locale)) {
			m_locale = loc;
		}
	}

//	public static void clearCache() {
//	}

	public Set getEnumeration() {
		return m_valueSet.entrySet();
	}

	public Map getEnumerationTexts() {
		return m_valueSet;
	}
}
