/*
 * Created on Feb 7, 2005
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.sap.caf.rt.ui.cool.metadata;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.naming.InitialContext;

import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.srv.IDataContainerBean;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;
import com.sap.typeservices.ModifiableSimpleValueSet;

/**
 * @author Alexey_Bloudov
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class TypedFieldDescriptorFactory {
	/** Logging properites for this class */
	private static final String APPLICATION = TypedFieldService.class.getName();
	private static final String jARMRequest = "CAF:RT:oal" + APPLICATION;
	private static final Location logger = Location.getLocation(APPLICATION);
	private static final String SERVICE_NAME_LOCAL =
		"localejbs/sap.com/caf.tc/CustomEnumTypeService";
	private static final String METHOD_FIND = "findByLocales";
	private static final String METHOD_UNIFY = "unifyKeyValuesInType";
	private static final String PROP_VALUEKEY = "valueKey";
	private static final String PROP_VALUE = "value";

	private Object customEnumTypeServiceLocal;
	private Method findByLocalesMethod;

	public TypedFieldDescriptorFactory() {
	}

	public TypedFieldDescriptor getTypedFieldDescriptor(
		String name,
		String type,
		String customType,
		ClassLoader cl,
		Locale locale) {
		TypedFieldDescriptor tfd =
			new TypedFieldDescriptor(name, type, customType, cl, locale);
		addRequiredServices(tfd);
		return tfd;
	}

	public TypedFieldDescriptor getTypedFieldDescriptor(
		String name,
		String type,
		ClassLoader cl) {
		TypedFieldDescriptor tfd = new TypedFieldDescriptor(name, type, cl);
		addRequiredServices(tfd);
		return tfd;
	}

	private void addRequiredServices(TypedFieldDescriptor tfd) {
		if (tfd.isCustomEnumType()) {
			ModifiableSimpleValueSet valueSet =
				getCETValues(tfd.getCustomType(), tfd.getDefaultLocale());
			TypedFieldService tfs =
				new TypedFieldService(
					tfd.getCustomType(),
					tfd.getDefaultLocale(),
					valueSet);
			tfd.setSimpleValueService(tfs);
		}
	}

	private ModifiableSimpleValueSet getCETValues(String type, Locale loc) {
		final String method = jARMRequest + ":getCETValues(String,Locale)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger);
		ModifiableSimpleValueSet set = new ModifiableSimpleValueSet(loc);
		try {
			set.setLocale(loc);
			List localeNames = calculateLocaleNames(loc);
			Object[] parameters = new Object[] { "*", type, localeNames };

			Collection sortedValues =
				findSortedValuesDirectlyFromEnumService(parameters);

			for (Iterator i = sortedValues.iterator(); i.hasNext();) {
				IDataContainerBean value = (IDataContainerBean) i.next();
				set.put(
					value.getProperty(PROP_VALUEKEY),
					value.getProperty(PROP_VALUE));
			}
		} catch (Exception e) {
			CAFPublicLogger.traceThrowable(
				Severity.ERROR,
				logger,
				method,
				e);
		} 
		CAFPublicLogger.exiting(null, jARMRequest, method, logger);
		return set;
	}

	protected static List calculateLocaleNames(Locale locale) {
		final List result = new ArrayList(4);
		final String language = locale.getLanguage();
		final int languageLength = language.length();
		final String country = locale.getCountry();
		final int countryLength = country.length();
		result.add(null); // Add root locale
		result.add(language);
		if (languageLength > 0 && countryLength > 0) {
			result.add(language + "_" + country);
		}
		return result;
	}

	private Collection findSortedValuesDirectlyFromEnumService(Object[] params) 
	throws Exception{
		Collection result = null;
		

			Method findByLocales_meth = getFindMethod();

			if (findByLocales_meth != null) {
				result =
					(Collection) findByLocales_meth.invoke(
						getLocalService(),
						params);
			}
		
		return result;
	}

	private Method getFindMethod() throws Exception {
		if (findByLocalesMethod == null) {
			findByLocalesMethod =
				getLocalService().getClass().getMethod(
					"findByLocales",
					new Class[] {
						String.class,
						String.class,
						Collection.class });
		}
		return findByLocalesMethod;
	}

	private Object getLocalService() throws Exception {
		if (customEnumTypeServiceLocal == null) {
			InitialContext ic = new InitialContext();
			Object home = ic.lookup(SERVICE_NAME_LOCAL);
			Method cr_meth = home.getClass().getMethod("create", new Class[0]);
			customEnumTypeServiceLocal = cr_meth.invoke(home, new Object[0]);
		}
		return customEnumTypeServiceLocal;
	}
}
